# Supplementary Files for "A Learnability Analysis on Neuro-Symbolic Learning"

This repository contains the supplementary files for the paper "A Learnability Analysis on Neuro-Symbolic Learning," submitted to the 39th annual conference on neural information processing systems(NeurIPS'2025). Please do not distribute these files.

The supplementary files are provided to help reproduce the experiments presented in the paper. The implementation is based on the code from [He et al., 2024](https://github.com/Hao-Yuan-He/A3BL).

By varying the `topk` parameter, the optimization objective can range from `PNL(k=-1)` to `ABL(k=1)`.  
> **Note:** While the optimization objective is the same as PNL or ABL, the optimization process may differ form the PNL (e.g., DeepProbLog, DeepStochLog or Semantic Loss) and ABL, which could result in slightly different experimental outcomes compared to the official implementation.


## Set up 
```bash
# Require swi-prolog >= 8.0
# In ubuntu system  22.04 or higher
sudo apt install swi-prolog
# Otherwise, please download the specific version of swi-prolog and install it manually.
```

```bash
# Create Conda Enviroment
conda create --name nesy python=3.10 
conda activate nesy 

# setup the package
pip install -v -e .

# Login your wandb account(if not, the logging process will encounter error.)
# The main results can be seen on the **wandb webpage, check it please!**
wandb login
```

## Experiment reproduce

### Learnability 

```bash 
# Addition
cd examples/addition

# dataset in [MNIST, KMNIST, SVHN, CIFAR]
# digit_size in [1, 2, 3, 4]
# Note: if digit_size is 2,3,4 the learning process will not be very quick, be patient.
python wsabl.py --dataset $dataset --digit_size $digit_size --topk $topk

# Multiplication
cd examples/multiplication

# dataset in [MNIST, KMNIST, SVHN, CIFAR]
# digit_size in [1, 2, 3, 4]
# Note: if digit_size is 2,3,4 the learning process will not be very quick, be patient.
python wsabl.py --dataset $dataset --digit_size $digit_size --topk $topk


```


### Impact of DCSP solution disagreement
```bash

# Mod addition
cd  examples/ensembleAdditionMod


# dataset in [MNIST, KMNIST, SVHN, CIFAR]
# digit_size in [1, 2, 3, 4]
# Note: if digit_size is 2,3,4 the learning process will not be very quick, be patient.
# Because of symmetric, we enforce mod1 <= mod2
python wsabl.py --dataset $dataset --digit_size $digit_size --pretrained --mod1 $mod1 --mod2 $mod2 --topk $topk

```



## License
This code is provided solely for peer review. It will be publicly released after acceptance of the paper.