from PIL import Image

def resize_image(file_path: str, output_size: tuple) -> None:
    """
    Resize an image to the specified dimensions and save it back to the original location.
    
    Args:
    file_path (str): The path to the image file.
    output_size (tuple): The new size of the image as a tuple (width, height).
    """
    try:
        # Open the image file
        with Image.open(file_path) as img:
            # Resize the image
            img = img.resize(output_size, Image.Resampling.LANCZOS)
            # Save the image back to the original file
            img.save(file_path)
            print(f"Image resized and saved back to {file_path}")
    except Exception as e:
        print(f"An error occurred: {e}")

# Example usage
resize_image('inputs/012575.jpg', (64, 64))
