# Anglican experiments

This folder contains a translation of the benchmarks to Anglican, so Anglican's inference algorithms can be run on them.

## Setup

The easiest way to install and run Anglican is in a Docker container.
To run the container, you need a [Docker installation](https://docs.docker.com/engine/install/).

## Running

To run Anglican in this directory, use this command:

```
docker run --rm -it -p 65301:65301 -v ${PWD}:/pwd -v ~/.docker_m2:/root/.m2 --name anglican clojure:openjdk-8-lein /bin/bash -c "cd /pwd; lein gorilla :port 65301 :ip 0.0.0.0"
```

This will open a browser window with a Gorilla notebook environment.

## Using the notebook

You can use the key combination `Alt+G Alt+L` to open a benchmark file.
After opening one, you can use the key combination `Alt+Shift+Enter` to evaluate the notebook, i.e. to run a set of Anglican's inference methods on the benchmark.
Note that this can take around an hour per benchmark.
The results will be saved as JSON files in `output/`.