;; gorilla-repl.fileformat = 1

;; @@

(ns model
  (:require [gorilla-plot.core :as plot])
  (:use [anglican core emit runtime stat
          [state :only [get-predicts get-log-weight get-result]]]))

(defdist geometric
"Geometric distribution on support {0,1,2....}"
[p] []
(sample* [this]
        (loop [value 0]
            (if (sample* (flip p))
            value
            (recur (inc value)))))
(observe* [this value] (+ (log p) (* value (log (- 1 p))))))

(defdist dirac [x]
    (sample* [this] x)
    (observe* [this value]
              (if (= value x)
                0
                (- (/ 1.0 0.0)))))


(with-primitive-procedures [dirac geometric]
  (defquery model [method- options- ]
    (let [[ a b c] [ 0 0 0 ]
          [ a b c]
          (let [
                a (+ 0 1)
                b (sample (geometric 0.1))
                c (sample (geometric 0.1))
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 4)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 4)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 1)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 1)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 1)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 1)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 4)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 4)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 3)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 3)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 3)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 3)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 5)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 5)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 1)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 1)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 3)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 3)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 1)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 1)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 3)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 3)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 3)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 3)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 0)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 0)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 2)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 2)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 6)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 6)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
                [ a b c] (cond
                  (= a 0)
                  (let [
                        _unused (observe (if (zero? (* 0.1 b)) (dirac 0) (poisson (* 0.1 b))) 1)
                        a (sample (bernoulli 0.2))
                       ]
                    [ a b c ]
                  )
                  :else
                  (let [
                        _unused (observe (if (zero? (* 0.1 c)) (dirac 0) (poisson (* 0.1 c))) 1)
                        a (sample (bernoulli 0.8))
                       ]
                    [ a b c ]
                  )
                )
               ]
            [ a b c ]
          )
         ]
    c
    )
  )

)


(def model_name "hmm")
(def outfile "output/hmm_anglican.json")

; (def configurations [:rmh []])
(def configurations
  [
    [:importance []]
    [:lmh []]
    [:rmh []]
    [:rmh [:alpha 0.8 :sigma 2]]
    [:smc []]
    [:smc [:number-of-particles 1000]]
    [:pgibbs []]
    [:pgibbs [:number-of-particles 1000]]
    [:ipmcmc []]
    [:ipmcmc [:number-of-particles 1000 :number-of-nodes 32]]
  ])

; (def num_samples_options [1000])
(def num_samples_options [1000 10000])
(def thinning 1)

(spit outfile "[\n" :append false)

(def num-chains 20)

(doall
  (for [ num_samples num_samples_options
         [method options] configurations
         chain (range 0 num-chains)]
    (do
      (println (format "\nMethod %s with %s samples and options %s" method num_samples options))
      (println (format "Chain no. %s" chain))
      (let [start (. System (nanoTime))
            warmup (/ num_samples 5)
            samples (take-nth thinning (take (* num_samples thinning) (drop warmup (apply doquery method model [method options] options))))
            results (collect-results samples)
            values (map (fn [s] (get-result s)) samples)
            max-value (apply max values)
            mean (empirical-mean results)
            variance (empirical-variance results)
            std (empirical-std results)
            skewness (if (zero? std) (/ 0.0 0.0) (empirical-skew results))
            kurtosis (if (zero? std) (/ 0.0 0.0) (empirical-kurtosis results))
            distribution (empirical-distribution (collect-results samples))
            masses (for [n (range 0 (inc max-value))] (get distribution n 0.0))
            end (. System (nanoTime))
            elapsed_ms (/ (- end start) 1e6)]
        (println (format "Elapsed time: %s ms" elapsed_ms))
        (println (format "Empirical mean: %s" mean))
        (println (format "Empirical variance: %s" variance))
        (println (format "Empirical std: %s" std))
        (println (format "Empirical skewness: %s" skewness))
        (println (format "Empirical kurtosis: %s" kurtosis))
        (spit outfile (format
                   "{\"model\": \"%s\", \"system\": \"anglican\", \"method\": \"%s\", \"options\": \"%s\", \"num_samples\": %s, \"time_ms\": %s, \"total\": 1.0, \"mean\": %s, \"variance\": %s, \"stddev\": %s, \"skewness\": %s, \"kurtosis\": %s, \"masses\": [%s] },\n"
                   model_name method options num_samples elapsed_ms mean variance std skewness kurtosis
                   (clojure.string/join ", " masses)) :append true)
        (if false (do
          (println "Empirical distribution:")
          (doall (for [n (range 0 (inc max-value))]
            (println (format "p(%s) = %s" n (get distribution n 0.0)))))))
        ; (println "List of samples (format: sample log-weight):")
        ; (doall (map (fn [s] (println (format "%s %s" (get-result s) (get-log-weight s)))) samples))
        ; values need to be adjusted if they are weighted!
        ; (plot/histogram values :normalize :probability)
      )
    )
  )
)

(spit outfile "]\n" :append true)




;; @@
;; ->
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 904.409312 ms
;;; Empirical mean: 20.042193853796324
;;; Empirical variance: 58.25377946734109
;;; Empirical std: 7.632416358358674
;;; Empirical skewness: 0.4514349750644551
;;; Empirical kurtosis: 2.0816001811560536
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 742.267129 ms
;;; Empirical mean: 18.89184137708392
;;; Empirical variance: 29.72893748258928
;;; Empirical std: 5.452424917648044
;;; Empirical skewness: -0.4251202669121457
;;; Empirical kurtosis: 2.2058423934010083
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 640.912266 ms
;;; Empirical mean: 15.555476720149066
;;; Empirical variance: 29.1806741369198
;;; Empirical std: 5.401913932757519
;;; Empirical skewness: 0.7140038993469601
;;; Empirical kurtosis: 3.0362498127482778
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 628.447586 ms
;;; Empirical mean: 18.634260152255713
;;; Empirical variance: 17.476266940503017
;;; Empirical std: 4.180462527101877
;;; Empirical skewness: -2.4784183153440256
;;; Empirical kurtosis: 8.693164400956821
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 636.750406 ms
;;; Empirical mean: 17.428581919651386
;;; Empirical variance: 78.87935137359415
;;; Empirical std: 8.881404808564586
;;; Empirical skewness: 0.611223367940844
;;; Empirical kurtosis: 2.0917517936248844
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 639.246751 ms
;;; Empirical mean: 25.33686193891749
;;; Empirical variance: 29.016982405461743
;;; Empirical std: 5.386741353124516
;;; Empirical skewness: -2.030767478014774
;;; Empirical kurtosis: 6.002306188253759
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 667.61553 ms
;;; Empirical mean: 19.63534131544189
;;; Empirical variance: 8.690008446704102
;;; Empirical std: 2.947882027270444
;;; Empirical skewness: -0.8631987002209959
;;; Empirical kurtosis: 8.07023048803673
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 699.560729 ms
;;; Empirical mean: 19.97811377318175
;;; Empirical variance: 43.05166133457845
;;; Empirical std: 6.56137648169791
;;; Empirical skewness: -0.06773714917619367
;;; Empirical kurtosis: 3.9379539233845686
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 615.353346 ms
;;; Empirical mean: 17.311670436664624
;;; Empirical variance: 36.86704429294463
;;; Empirical std: 6.0718238028573115
;;; Empirical skewness: 0.11322284343885945
;;; Empirical kurtosis: 1.4577456628236778
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 876.611882 ms
;;; Empirical mean: 12.524312330607367
;;; Empirical variance: 39.7433351690407
;;; Empirical std: 6.3042315288257535
;;; Empirical skewness: -0.22270252521903355
;;; Empirical kurtosis: 1.6939716336774817
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 884.877987 ms
;;; Empirical mean: 12.569839343730164
;;; Empirical variance: 64.25930109536996
;;; Empirical std: 8.016189936333218
;;; Empirical skewness: 0.969086794848902
;;; Empirical kurtosis: 2.9620597011714036
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 820.610425 ms
;;; Empirical mean: 20.94760075495842
;;; Empirical variance: 11.376842896061003
;;; Empirical std: 3.3729575888322407
;;; Empirical skewness: -2.2905069512652423
;;; Empirical kurtosis: 9.642128224766278
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 621.854839 ms
;;; Empirical mean: 25.555140820637785
;;; Empirical variance: 19.74384491450177
;;; Empirical std: 4.443404653472579
;;; Empirical skewness: -3.108834984534135
;;; Empirical kurtosis: 12.322647890447367
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 870.884315 ms
;;; Empirical mean: 9.423548550594543
;;; Empirical variance: 35.969875894046886
;;; Empirical std: 5.997489132465926
;;; Empirical skewness: 1.3797471979944
;;; Empirical kurtosis: 3.3508602783246677
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 632.515826 ms
;;; Empirical mean: 17.90183254528139
;;; Empirical variance: 54.48912381056651
;;; Empirical std: 7.381674864864106
;;; Empirical skewness: 1.203838472158243
;;; Empirical kurtosis: 3.581767654838777
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 642.311397 ms
;;; Empirical mean: 10.080742817956285
;;; Empirical variance: 57.335604539405345
;;; Empirical std: 7.572027769323443
;;; Empirical skewness: 1.2422022089815545
;;; Empirical kurtosis: 3.1065174583115267
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 629.937374 ms
;;; Empirical mean: 21.086819172204628
;;; Empirical variance: 33.42187678563011
;;; Empirical std: 5.781165694358718
;;; Empirical skewness: -1.154085632201413
;;; Empirical kurtosis: 2.8048333685058475
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 621.95268 ms
;;; Empirical mean: 18.11071256156849
;;; Empirical variance: 41.47580511046721
;;; Empirical std: 6.440171201953191
;;; Empirical skewness: -0.15028786587680767
;;; Empirical kurtosis: 1.658138023582099
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 613.135607 ms
;;; Empirical mean: 20.184782254694568
;;; Empirical variance: 10.445427495680859
;;; Empirical std: 3.23193865902199
;;; Empirical skewness: -2.0451003142201483
;;; Empirical kurtosis: 9.396755454957816
;;; 
;;; Method :importance with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 672.910325 ms
;;; Empirical mean: 18.15867203073279
;;; Empirical variance: 30.00923967803362
;;; Empirical std: 5.478068973464429
;;; Empirical skewness: -0.7336599072197776
;;; Empirical kurtosis: 2.1359312243210122
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 533.300271 ms
;;; Empirical mean: 23.95
;;; Empirical variance: 43.75749999999999
;;; Empirical std: 6.614945200075356
;;; Empirical skewness: 0.06852137709920471
;;; Empirical kurtosis: 1.0969706749596513
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 486.019549 ms
;;; Empirical mean: 22.968
;;; Empirical variance: 5.126975999999999
;;; Empirical std: 2.2642826678663597
;;; Empirical skewness: -1.7382988687136418
;;; Empirical kurtosis: 4.0216829569711265
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 419.402267 ms
;;; Empirical mean: 9.956999999999997
;;; Empirical variance: 26.903151000000012
;;; Empirical std: 5.1868247512326855
;;; Empirical skewness: 0.18821286248107277
;;; Empirical kurtosis: 1.828827437264305
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 432.250517 ms
;;; Empirical mean: 23.299
;;; Empirical variance: 9.31959900000001
;;; Empirical std: 3.052801827829643
;;; Empirical skewness: -2.4205715166379442
;;; Empirical kurtosis: 7.715018329928981
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 438.780236 ms
;;; Empirical mean: 17.622000000000003
;;; Empirical variance: 30.773116000000034
;;; Empirical std: 5.547352161166626
;;; Empirical skewness: 3.1668613668014522
;;; Empirical kurtosis: 11.178875921405199
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 744.223715 ms
;;; Empirical mean: 6.720000000000001
;;; Empirical variance: 11.315600000000009
;;; Empirical std: 3.3638668225719055
;;; Empirical skewness: 2.38510527404449
;;; Empirical kurtosis: 9.267732873542416
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 509.510619 ms
;;; Empirical mean: 20.921999999999997
;;; Empirical variance: 20.84191600000001
;;; Empirical std: 4.565294733092268
;;; Empirical skewness: 0.1273730734633149
;;; Empirical kurtosis: 2.454309640303685
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 424.656784 ms
;;; Empirical mean: 25.442999999999998
;;; Empirical variance: 15.430751000000004
;;; Empirical std: 3.928199460312575
;;; Empirical skewness: -0.0811251487212267
;;; Empirical kurtosis: 3.0071072114873596
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 405.144427 ms
;;; Empirical mean: 6.840000000000001
;;; Empirical variance: 10.550400000000007
;;; Empirical std: 3.2481379281058875
;;; Empirical skewness: 1.6769683702949347
;;; Empirical kurtosis: 3.976235461526079
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 442.579083 ms
;;; Empirical mean: 10.334999999999999
;;; Empirical variance: 2.646775000000002
;;; Empirical std: 1.6268912071801243
;;; Empirical skewness: -0.9332536634079139
;;; Empirical kurtosis: 6.641306765435672
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 412.848484 ms
;;; Empirical mean: 24.645
;;; Empirical variance: 4.776975000000005
;;; Empirical std: 2.1856292000245614
;;; Empirical skewness: -2.039402608077316
;;; Empirical kurtosis: 7.179970081129852
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 459.648916 ms
;;; Empirical mean: 31.44299999999999
;;; Empirical variance: 55.214751000000035
;;; Empirical std: 7.430662891021234
;;; Empirical skewness: -0.43313198044199586
;;; Empirical kurtosis: 2.4167719566818473
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 382.545883 ms
;;; Empirical mean: 24.414
;;; Empirical variance: 23.432604000000005
;;; Empirical std: 4.840723499643416
;;; Empirical skewness: 0.663027824046534
;;; Empirical kurtosis: 1.9873521026965855
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 391.51469 ms
;;; Empirical mean: 27.583999999999996
;;; Empirical variance: 14.034944000000005
;;; Empirical std: 3.746324065000251
;;; Empirical skewness: 0.5411163913340824
;;; Empirical kurtosis: 1.6943299651854522
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 388.617178 ms
;;; Empirical mean: 25.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 403.638906 ms
;;; Empirical mean: 8.867999999999999
;;; Empirical variance: 4.512576000000001
;;; Empirical std: 2.124282467093301
;;; Empirical skewness: -0.4348764855259891
;;; Empirical kurtosis: 3.1042472816645112
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 408.227148 ms
;;; Empirical mean: 28.112000000000002
;;; Empirical variance: 10.811455999999996
;;; Empirical std: 3.288077857958962
;;; Empirical skewness: 0.1827888962864882
;;; Empirical kurtosis: 1.2156898830405283
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 394.122615 ms
;;; Empirical mean: 23.345999999999997
;;; Empirical variance: 10.636283999999998
;;; Empirical std: 3.2613316298714543
;;; Empirical skewness: -0.14050453703167276
;;; Empirical kurtosis: 1.4264152528970322
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 392.416862 ms
;;; Empirical mean: 21.779000000000007
;;; Empirical variance: 13.488159000000012
;;; Empirical std: 3.6726229046827026
;;; Empirical skewness: 0.254526176617778
;;; Empirical kurtosis: 3.0132387292319756
;;; 
;;; Method :lmh with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 519.975486 ms
;;; Empirical mean: 25.517999999999994
;;; Empirical variance: 3.557675999999999
;;; Empirical std: 1.8861802671006818
;;; Empirical skewness: -0.5098967306327834
;;; Empirical kurtosis: 1.2972951345575165
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 570.839021 ms
;;; Empirical mean: 11.006999999999998
;;; Empirical variance: 3.478951000000001
;;; Empirical std: 1.8651946279142027
;;; Empirical skewness: -0.45308895618975636
;;; Empirical kurtosis: 2.2761357570635714
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 450.658007 ms
;;; Empirical mean: 5.810999999999999
;;; Empirical variance: 4.847279
;;; Empirical std: 2.2016536966562206
;;; Empirical skewness: -0.25879252664334645
;;; Empirical kurtosis: 2.3463826649538433
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 429.403888 ms
;;; Empirical mean: 9.269
;;; Empirical variance: 3.3346390000000024
;;; Empirical std: 1.826099394885175
;;; Empirical skewness: -0.4078441253867566
;;; Empirical kurtosis: 3.3696815641694564
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 447.089139 ms
;;; Empirical mean: 20.336
;;; Empirical variance: 0.2231039999999999
;;; Empirical std: 0.47233886141201625
;;; Empirical skewness: 0.6944167139232977
;;; Empirical kurtosis: 1.4822145725760276
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 439.10153 ms
;;; Empirical mean: 21.400000000000006
;;; Empirical variance: 23.340000000000018
;;; Empirical std: 4.831148931672467
;;; Empirical skewness: 3.474028185678475
;;; Empirical kurtosis: 13.419785312899926
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 592.397543 ms
;;; Empirical mean: 22.149
;;; Empirical variance: 22.916799
;;; Empirical std: 4.78714936052762
;;; Empirical skewness: 0.015695410512583056
;;; Empirical kurtosis: 1.0214020722418404
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 465.890903 ms
;;; Empirical mean: 6.980999999999999
;;; Empirical variance: 2.3886390000000004
;;; Empirical std: 1.5455222418328376
;;; Empirical skewness: 0.02686009813884725
;;; Empirical kurtosis: 2.1626770619747053
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 455.94131 ms
;;; Empirical mean: 22.32
;;; Empirical variance: 9.415600000000001
;;; Empirical std: 3.068484968188699
;;; Empirical skewness: -0.1062502985012489
;;; Empirical kurtosis: 1.062381260782413
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 456.66844 ms
;;; Empirical mean: 5.055000000000001
;;; Empirical variance: 1.5619750000000003
;;; Empirical std: 1.249789982357036
;;; Empirical skewness: -0.3836261633442203
;;; Empirical kurtosis: 2.3155489207705475
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 443.309546 ms
;;; Empirical mean: 23.284
;;; Empirical variance: 48.859344
;;; Empirical std: 6.989945922537599
;;; Empirical skewness: 0.8117520077235252
;;; Empirical kurtosis: 1.8094369385454818
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 442.322382 ms
;;; Empirical mean: 26.300999999999995
;;; Empirical variance: 21.816399000000008
;;; Empirical std: 4.670802821785566
;;; Empirical skewness: -0.7682080854329549
;;; Empirical kurtosis: 1.6425849653768194
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 578.802325 ms
;;; Empirical mean: 23.973
;;; Empirical variance: 56.240270999999986
;;; Empirical std: 7.499351371952109
;;; Empirical skewness: 1.2891486209438923
;;; Empirical kurtosis: 2.7806845886828038
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 546.861595 ms
;;; Empirical mean: 21.884
;;; Empirical variance: 6.1285440000000015
;;; Empirical std: 2.475589626735417
;;; Empirical skewness: -0.3435135942046692
;;; Empirical kurtosis: 1.896554634946521
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 461.576085 ms
;;; Empirical mean: 22.508000000000003
;;; Empirical variance: 9.063936000000002
;;; Empirical std: 3.010637141868811
;;; Empirical skewness: -0.2962646252825581
;;; Empirical kurtosis: 1.1122487487873887
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 461.07235 ms
;;; Empirical mean: 5.198
;;; Empirical variance: 4.430796000000001
;;; Empirical std: 2.1049456049979063
;;; Empirical skewness: 0.8196296006554237
;;; Empirical kurtosis: 2.359414367094888
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 495.00493 ms
;;; Empirical mean: 8.741
;;; Empirical variance: 3.449919000000002
;;; Empirical std: 1.8573957575056539
;;; Empirical skewness: -0.6840092630842721
;;; Empirical kurtosis: 2.368952041341752
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 502.926392 ms
;;; Empirical mean: 8.653
;;; Empirical variance: 9.060591
;;; Empirical std: 3.0100815603567956
;;; Empirical skewness: 0.033690946430707004
;;; Empirical kurtosis: 1.9313399016743509
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 510.242169 ms
;;; Empirical mean: 17.593
;;; Empirical variance: 1.9773510000000019
;;; Empirical std: 1.4061831317435158
;;; Empirical skewness: 2.226479223006847
;;; Empirical kurtosis: 6.593707288089979
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 559.869051 ms
;;; Empirical mean: 4.863000000000001
;;; Empirical variance: 2.6622310000000025
;;; Empirical std: 1.631634456610917
;;; Empirical skewness: 1.484821207860293
;;; Empirical kurtosis: 5.4551601695934435
;;; 
;;; Method :rmh with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 484.928424 ms
;;; Empirical mean: 20.508000000000003
;;; Empirical variance: 29.909936
;;; Empirical std: 5.4689977143897215
;;; Empirical skewness: 0.0735686171302616
;;; Empirical kurtosis: 1.1741235257442204
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 1141.043131 ms
;;; Empirical mean: 15.84994769012554
;;; Empirical variance: 46.8842774675844
;;; Empirical std: 6.8472094657301374
;;; Empirical skewness: -0.270445077511308
;;; Empirical kurtosis: 2.1040974993685277
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 1030.520399 ms
;;; Empirical mean: 17.209232528032977
;;; Empirical variance: 18.035224928236495
;;; Empirical std: 4.2467899557473405
;;; Empirical skewness: -0.9777999543312291
;;; Empirical kurtosis: 4.533652458325912
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 980.549898 ms
;;; Empirical mean: 16.636974294762798
;;; Empirical variance: 113.351614938757
;;; Empirical std: 10.64667154272907
;;; Empirical skewness: 0.0362785937015495
;;; Empirical kurtosis: 1.3257060324101064
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 1258.302758 ms
;;; Empirical mean: 18.92064994506007
;;; Empirical variance: 7.22249901339009
;;; Empirical std: 2.687470746518014
;;; Empirical skewness: 0.2512852050399552
;;; Empirical kurtosis: 7.385303690518773
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 1003.088029 ms
;;; Empirical mean: 10.995535963131365
;;; Empirical variance: 20.886379378359592
;;; Empirical std: 4.5701618547223894
;;; Empirical skewness: 2.2071243333923363
;;; Empirical kurtosis: 8.712926967639085
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 940.231522 ms
;;; Empirical mean: 17.073304519506763
;;; Empirical variance: 12.428064500642606
;;; Empirical std: 3.5253460114778243
;;; Empirical skewness: -0.8784034953161867
;;; Empirical kurtosis: 3.2042593699226694
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 1096.164762 ms
;;; Empirical mean: 29.21380079596457
;;; Empirical variance: 12.970320639963463
;;; Empirical std: 3.6014331369558232
;;; Empirical skewness: -4.6671652618632855
;;; Empirical kurtosis: 23.76466782666398
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 947.483637 ms
;;; Empirical mean: 20.800329707474166
;;; Empirical variance: 31.170446321990575
;;; Empirical std: 5.583049912188729
;;; Empirical skewness: 0.2267067149331518
;;; Empirical kurtosis: 5.144068402746256
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 971.876393 ms
;;; Empirical mean: 13.809170268392087
;;; Empirical variance: 47.40360629237116
;;; Empirical std: 6.885027690022108
;;; Empirical skewness: 1.2145762098856931
;;; Empirical kurtosis: 3.3530538938076444
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 941.035655 ms
;;; Empirical mean: 26.177810506449127
;;; Empirical variance: 11.496587750056392
;;; Empirical std: 3.390661845430239
;;; Empirical skewness: -3.5409949218376195
;;; Empirical kurtosis: 15.623554696313583
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 980.154049 ms
;;; Empirical mean: 19.594956031767996
;;; Empirical variance: 10.6183565074547
;;; Empirical std: 3.2585819780166188
;;; Empirical skewness: -1.9774766000035213
;;; Empirical kurtosis: 7.714541398301987
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 965.351511 ms
;;; Empirical mean: 22.32046690487085
;;; Empirical variance: 8.851656370721386
;;; Empirical std: 2.975173334567481
;;; Empirical skewness: -4.553107297528033
;;; Empirical kurtosis: 22.777785839254182
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 931.649407 ms
;;; Empirical mean: 17.36016484229088
;;; Empirical variance: 20.70834456845063
;;; Empirical std: 4.550642214946219
;;; Empirical skewness: -0.6470276845807109
;;; Empirical kurtosis: 3.450207891005699
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 939.00776 ms
;;; Empirical mean: 29.67588257691918
;;; Empirical variance: 44.06610776586643
;;; Empirical std: 6.6382307707601145
;;; Empirical skewness: -1.7243674234145887
;;; Empirical kurtosis: 4.570686686718125
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 953.812408 ms
;;; Empirical mean: 20.78349867642513
;;; Empirical variance: 33.14893106398863
;;; Empirical std: 5.757510839241958
;;; Empirical skewness: 1.3580640630246341
;;; Empirical kurtosis: 3.8002108881856236
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 970.761353 ms
;;; Empirical mean: 19.14622546234222
;;; Empirical variance: 5.628778840923014
;;; Empirical std: 2.3725047609905894
;;; Empirical skewness: -2.3356370685404237
;;; Empirical kurtosis: 7.282737398158069
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 949.02004 ms
;;; Empirical mean: 11.493313938141428
;;; Empirical variance: 30.534937703242704
;;; Empirical std: 5.525842714305457
;;; Empirical skewness: 1.0957986892393752
;;; Empirical kurtosis: 4.151878339790947
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 926.277319 ms
;;; Empirical mean: 16.14032791985129
;;; Empirical variance: 112.80086706442926
;;; Empirical std: 10.620775257222482
;;; Empirical skewness: 0.2345793877086441
;;; Empirical kurtosis: 1.2246292736597006
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 947.073011 ms
;;; Empirical mean: 11.711503335162924
;;; Empirical variance: 59.23897601530239
;;; Empirical std: 7.69668604110252
;;; Empirical skewness: 0.3907305177509013
;;; Empirical kurtosis: 1.9553920958586395
;;; 
;;; Method :smc with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 923.813032 ms
;;; Empirical mean: 17.414000143030776
;;; Empirical variance: 9.160428272045166
;;; Empirical std: 3.0266199417907043
;;; Empirical skewness: 0.032808059572576376
;;; Empirical kurtosis: 4.305610537225467
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 0
;;; Elapsed time: 618.226877 ms
;;; Empirical mean: 25.042275955180685
;;; Empirical variance: 26.2883176557744
;;; Empirical std: 5.127213439654565
;;; Empirical skewness: -1.5466773655034058
;;; Empirical kurtosis: 6.505177903217315
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 1
;;; Elapsed time: 640.118252 ms
;;; Empirical mean: 23.65538217504649
;;; Empirical variance: 47.76617630986234
;;; Empirical std: 6.91130785813093
;;; Empirical skewness: -1.0965064837092728
;;; Empirical kurtosis: 4.0539127386942235
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 2
;;; Elapsed time: 633.586163 ms
;;; Empirical mean: 23.96070464389236
;;; Empirical variance: 21.56703088163126
;;; Empirical std: 4.644031748559786
;;; Empirical skewness: -0.48677421299200235
;;; Empirical kurtosis: 4.657515817935008
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 3
;;; Elapsed time: 649.973688 ms
;;; Empirical mean: 24.804033900358565
;;; Empirical variance: 29.181086221852688
;;; Empirical std: 5.4019520751162435
;;; Empirical skewness: -1.3091459322840377
;;; Empirical kurtosis: 6.75248112617017
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 4
;;; Elapsed time: 630.676536 ms
;;; Empirical mean: 20.587756223631654
;;; Empirical variance: 49.84204088823682
;;; Empirical std: 7.059889580456399
;;; Empirical skewness: -0.874468684343602
;;; Empirical kurtosis: 2.6019472754467188
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 5
;;; Elapsed time: 657.127909 ms
;;; Empirical mean: 22.967477598325207
;;; Empirical variance: 27.640220177934452
;;; Empirical std: 5.257396711104694
;;; Empirical skewness: -1.9525680965581775
;;; Empirical kurtosis: 8.37844077629422
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 6
;;; Elapsed time: 637.009442 ms
;;; Empirical mean: 23.589071198079903
;;; Empirical variance: 17.920694460862798
;;; Empirical std: 4.233284122388054
;;; Empirical skewness: -1.2332072560056924
;;; Empirical kurtosis: 9.13882720974603
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 7
;;; Elapsed time: 642.887463 ms
;;; Empirical mean: 23.543432884143954
;;; Empirical variance: 21.629161334511018
;;; Empirical std: 4.65071621737029
;;; Empirical skewness: -0.8723210258770558
;;; Empirical kurtosis: 6.4335570527724695
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 8
;;; Elapsed time: 649.251474 ms
;;; Empirical mean: 21.99323443533247
;;; Empirical variance: 35.94407698865894
;;; Empirical std: 5.995337937819597
;;; Empirical skewness: -0.7237795269030576
;;; Empirical kurtosis: 4.914822396028721
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 9
;;; Elapsed time: 615.69594 ms
;;; Empirical mean: 24.045467030141825
;;; Empirical variance: 33.29547215372176
;;; Empirical std: 5.770222885965651
;;; Empirical skewness: -1.085317182358617
;;; Empirical kurtosis: 5.109039770985593
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 10
;;; Elapsed time: 624.854049 ms
;;; Empirical mean: 25.84408776864742
;;; Empirical variance: 14.911186776347208
;;; Empirical std: 3.8615005860866067
;;; Empirical skewness: -0.9115689974503748
;;; Empirical kurtosis: 6.25474320234878
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 11
;;; Elapsed time: 631.992392 ms
;;; Empirical mean: 23.927288856747058
;;; Empirical variance: 29.510958044281857
;;; Empirical std: 5.432398921681089
;;; Empirical skewness: -1.500846105105491
;;; Empirical kurtosis: 6.973895260917078
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 12
;;; Elapsed time: 656.333685 ms
;;; Empirical mean: 22.84565514587088
;;; Empirical variance: 48.277897373885594
;;; Empirical std: 6.948229801459188
;;; Empirical skewness: -1.3154032113652814
;;; Empirical kurtosis: 4.355929871863306
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 13
;;; Elapsed time: 632.161301 ms
;;; Empirical mean: 25.831333366123367
;;; Empirical variance: 37.310787985454176
;;; Empirical std: 6.108255723646005
;;; Empirical skewness: -1.2148293871091036
;;; Empirical kurtosis: 5.954282888048603
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 14
;;; Elapsed time: 637.111539 ms
;;; Empirical mean: 21.396755943013947
;;; Empirical variance: 63.30028967930382
;;; Empirical std: 7.956147917133254
;;; Empirical skewness: -0.9435203457421278
;;; Empirical kurtosis: 3.1474341375324113
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 15
;;; Elapsed time: 667.892047 ms
;;; Empirical mean: 22.84398789719373
;;; Empirical variance: 50.95554418975828
;;; Empirical std: 7.138315220677655
;;; Empirical skewness: -0.7912275545501166
;;; Empirical kurtosis: 3.5889503806158616
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 16
;;; Elapsed time: 639.457756 ms
;;; Empirical mean: 25.102645397326235
;;; Empirical variance: 14.999525612447977
;;; Empirical std: 3.8729221025535714
;;; Empirical skewness: -0.45806087277311325
;;; Empirical kurtosis: 5.151654382285799
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 17
;;; Elapsed time: 620.359717 ms
;;; Empirical mean: 23.637961573548342
;;; Empirical variance: 15.209013451381946
;;; Empirical std: 3.899873517356934
;;; Empirical skewness: -0.22867772886560023
;;; Empirical kurtosis: 5.549570691521009
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 18
;;; Elapsed time: 673.951887 ms
;;; Empirical mean: 24.21603040622712
;;; Empirical variance: 39.714987683343395
;;; Empirical std: 6.301982837436436
;;; Empirical skewness: -0.8930263804264839
;;; Empirical kurtosis: 4.6518186407320545
;;; 
;;; Method :smc with 1000 samples and options [:number-of-particles 100]
;;; Chain no. 19
;;; Elapsed time: 632.871544 ms
;;; Empirical mean: 24.108042475389784
;;; Empirical variance: 39.724509812822
;;; Empirical std: 6.302738278940511
;;; Empirical skewness: -0.8196153023845398
;;; Empirical kurtosis: 3.9804464545540594
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 764.608703 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 695.856663 ms
;;; Empirical mean: 14.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 706.148322 ms
;;; Empirical mean: 25.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 717.013557 ms
;;; Empirical mean: 14.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 710.460052 ms
;;; Empirical mean: 17.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 725.430604 ms
;;; Empirical mean: 3.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 708.593048 ms
;;; Empirical mean: 7.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 690.035091 ms
;;; Empirical mean: 3.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 718.459718 ms
;;; Empirical mean: 15.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 683.330038 ms
;;; Empirical mean: 24.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 703.276512 ms
;;; Empirical mean: 15.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 670.91964 ms
;;; Empirical mean: 18.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 762.62166 ms
;;; Empirical mean: 6.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 731.59322 ms
;;; Empirical mean: 34.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 700.081422 ms
;;; Empirical mean: 22.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 706.742534 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 695.947515 ms
;;; Empirical mean: 5.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 692.093956 ms
;;; Empirical mean: 14.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 710.955819 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 708.125578 ms
;;; Empirical mean: 21.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 392.219625 ms
;;; Empirical mean: 13.202825623110032
;;; Empirical variance: 44.963008770334554
;;; Empirical std: 6.705446202180326
;;; Empirical skewness: 0.2089080683416866
;;; Empirical kurtosis: 2.990212621584422
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 228.82665 ms
;;; Empirical mean: 14.554856504044004
;;; Empirical variance: 59.58781039220419
;;; Empirical std: 7.719314114103933
;;; Empirical skewness: 1.8626413791633047
;;; Empirical kurtosis: 6.72985507957669
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 236.611568 ms
;;; Empirical mean: 12.61007653740781
;;; Empirical variance: 88.25067413389321
;;; Empirical std: 9.394182994486174
;;; Empirical skewness: 1.561357209045484
;;; Empirical kurtosis: 5.163556141891213
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 243.49804 ms
;;; Empirical mean: 14.37996308660706
;;; Empirical variance: 45.32584697231995
;;; Empirical std: 6.732447324140008
;;; Empirical skewness: 0.6552647630739977
;;; Empirical kurtosis: 2.56548012442922
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 230.323312 ms
;;; Empirical mean: 16.623111222676282
;;; Empirical variance: 48.46426684408485
;;; Empirical std: 6.961628174793943
;;; Empirical skewness: 0.2139543547325693
;;; Empirical kurtosis: 2.1437225757331326
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 232.807998 ms
;;; Empirical mean: 14.367183459162876
;;; Empirical variance: 70.63656214577898
;;; Empirical std: 8.40455603501928
;;; Empirical skewness: 1.0597475517552781
;;; Empirical kurtosis: 3.8203187330175457
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 235.981896 ms
;;; Empirical mean: 15.383698602837923
;;; Empirical variance: 93.0929357847563
;;; Empirical std: 9.64846805377705
;;; Empirical skewness: 0.7909630224578285
;;; Empirical kurtosis: 2.9461744548453863
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 235.83672 ms
;;; Empirical mean: 14.884670806483907
;;; Empirical variance: 75.78376582745695
;;; Empirical std: 8.705387172748662
;;; Empirical skewness: 2.1741969564108103
;;; Empirical kurtosis: 7.908485128610253
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 229.734168 ms
;;; Empirical mean: 11.845213343019617
;;; Empirical variance: 39.391833142209286
;;; Empirical std: 6.276291352559191
;;; Empirical skewness: 0.8754407961539864
;;; Empirical kurtosis: 3.71295768328246
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 231.41342 ms
;;; Empirical mean: 18.50581262923571
;;; Empirical variance: 69.29195922202814
;;; Empirical std: 8.324179192090241
;;; Empirical skewness: 0.084399195100501
;;; Empirical kurtosis: 2.4425184680682697
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 229.427114 ms
;;; Empirical mean: 17.866256304514973
;;; Empirical variance: 53.553726351272935
;;; Empirical std: 7.318041155341567
;;; Empirical skewness: -0.1549470333862251
;;; Empirical kurtosis: 2.022411636929501
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 236.774332 ms
;;; Empirical mean: 12.826709396772948
;;; Empirical variance: 22.538691986230322
;;; Empirical std: 4.747493231825646
;;; Empirical skewness: 0.8324716490832546
;;; Empirical kurtosis: 4.024773114467435
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 238.948255 ms
;;; Empirical mean: 13.668951798800352
;;; Empirical variance: 54.72852898957122
;;; Empirical std: 7.3978732747710145
;;; Empirical skewness: 0.5736617817661471
;;; Empirical kurtosis: 2.386586843533948
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 232.308233 ms
;;; Empirical mean: 13.490412252130575
;;; Empirical variance: 31.91324601364951
;;; Empirical std: 5.649181003795993
;;; Empirical skewness: 0.36435924842482287
;;; Empirical kurtosis: 2.9744786040952147
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 229.792372 ms
;;; Empirical mean: 15.250954677688334
;;; Empirical variance: 28.750732531998427
;;; Empirical std: 5.361970955907765
;;; Empirical skewness: -0.05748814186048674
;;; Empirical kurtosis: 2.720316335642417
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 239.846836 ms
;;; Empirical mean: 14.849700542281385
;;; Empirical variance: 60.28911112315142
;;; Empirical std: 7.764606308316695
;;; Empirical skewness: 0.14717836197800252
;;; Empirical kurtosis: 2.371239657045805
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 238.070501 ms
;;; Empirical mean: 10.80862656189168
;;; Empirical variance: 33.43401722635555
;;; Empirical std: 5.782215598397863
;;; Empirical skewness: 1.1000318928533452
;;; Empirical kurtosis: 5.609171420080044
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 240.696326 ms
;;; Empirical mean: 17.624273583458578
;;; Empirical variance: 76.3768541592435
;;; Empirical std: 8.739385227763078
;;; Empirical skewness: 0.43309833211341914
;;; Empirical kurtosis: 2.3374523013198685
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 242.543295 ms
;;; Empirical mean: 14.732188756726677
;;; Empirical variance: 46.7797798895107
;;; Empirical std: 6.839574540094632
;;; Empirical skewness: -0.06323700725391289
;;; Empirical kurtosis: 1.5696477676410547
;;; 
;;; Method :ipmcmc with 1000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 231.753528 ms
;;; Empirical mean: 13.722471969004001
;;; Empirical variance: 35.9043773276012
;;; Empirical std: 5.992026145437051
;;; Empirical skewness: 0.07808145734300932
;;; Empirical kurtosis: 2.0459236707656427
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 6035.656843 ms
;;; Empirical mean: 13.307933618278716
;;; Empirical variance: 66.4483638842918
;;; Empirical std: 8.151586586934583
;;; Empirical skewness: 0.32687717714803294
;;; Empirical kurtosis: 1.408330162624174
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 6329.976503 ms
;;; Empirical mean: 20.55976534716335
;;; Empirical variance: 49.21670925551246
;;; Empirical std: 7.015462155518513
;;; Empirical skewness: 0.258829921851859
;;; Empirical kurtosis: 2.9399091252178544
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 6353.600839 ms
;;; Empirical mean: 24.842820496647878
;;; Empirical variance: 41.61400168777168
;;; Empirical std: 6.450891542087162
;;; Empirical skewness: 0.47560167734353104
;;; Empirical kurtosis: 2.7502269882494463
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 6249.281112 ms
;;; Empirical mean: 18.449422205754775
;;; Empirical variance: 35.44008584175059
;;; Empirical std: 5.9531576362255505
;;; Empirical skewness: -0.8862680718426642
;;; Empirical kurtosis: 2.798871735667983
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 6197.331571 ms
;;; Empirical mean: 24.779350211167095
;;; Empirical variance: 6.096793291940366
;;; Empirical std: 2.4691685426354284
;;; Empirical skewness: -2.141812553582174
;;; Empirical kurtosis: 18.638907344620986
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 6041.709504 ms
;;; Empirical mean: 24.89620662234246
;;; Empirical variance: 0.8752194535844846
;;; Empirical std: 0.9355316422144602
;;; Empirical skewness: -11.160628729131925
;;; Empirical kurtosis: 199.80602148534027
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 6046.68243 ms
;;; Empirical mean: 12.545448217971236
;;; Empirical variance: 67.6943877658713
;;; Empirical std: 8.227659920406975
;;; Empirical skewness: 0.46170348004600625
;;; Empirical kurtosis: 1.6634844011842829
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 6184.220629 ms
;;; Empirical mean: 13.133859792629375
;;; Empirical variance: 42.091999535762255
;;; Empirical std: 6.48783473400504
;;; Empirical skewness: 0.7710413616430961
;;; Empirical kurtosis: 2.4781575901775716
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 6035.554163 ms
;;; Empirical mean: 22.747625358463498
;;; Empirical variance: 1.3531377024286797
;;; Empirical std: 1.1632444723396194
;;; Empirical skewness: -6.578711083160183
;;; Empirical kurtosis: 96.9735290902509
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 6095.230454 ms
;;; Empirical mean: 24.98143098068267
;;; Empirical variance: 12.118026722978588
;;; Empirical std: 3.4810956210622237
;;; Empirical skewness: -4.152864815624142
;;; Empirical kurtosis: 23.232383228516262
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 6162.169574 ms
;;; Empirical mean: 19.60345663555253
;;; Empirical variance: 50.36396194626525
;;; Empirical std: 7.096757142967854
;;; Empirical skewness: -0.20168882911877348
;;; Empirical kurtosis: 2.2914922561386932
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 6238.118644 ms
;;; Empirical mean: 20.348054580128576
;;; Empirical variance: 11.68793750902333
;;; Empirical std: 3.4187625698523334
;;; Empirical skewness: -4.016332062624499
;;; Empirical kurtosis: 19.735650500793238
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 6225.030718 ms
;;; Empirical mean: 22.995602425049455
;;; Empirical variance: 23.74824475995336
;;; Empirical std: 4.873217085248036
;;; Empirical skewness: -0.9679251666483248
;;; Empirical kurtosis: 3.627470771834235
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 6352.104719 ms
;;; Empirical mean: 11.534485581171575
;;; Empirical variance: 26.434029010704602
;;; Empirical std: 5.141403408672053
;;; Empirical skewness: 1.2828404589471993
;;; Empirical kurtosis: 3.1237219426245737
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 6346.844817 ms
;;; Empirical mean: 21.59720326010697
;;; Empirical variance: 42.94504908965942
;;; Empirical std: 6.553247217193887
;;; Empirical skewness: -0.6043439195284805
;;; Empirical kurtosis: 3.0725759627575053
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 6157.368886 ms
;;; Empirical mean: 19.023126712234774
;;; Empirical variance: 13.647708576853866
;;; Empirical std: 3.6942805222199717
;;; Empirical skewness: 0.6144051895022707
;;; Empirical kurtosis: 4.735767806566121
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 6071.841398 ms
;;; Empirical mean: 17.265745442186233
;;; Empirical variance: 45.69728071610515
;;; Empirical std: 6.759976384286054
;;; Empirical skewness: 0.10562753968705574
;;; Empirical kurtosis: 2.16769743103663
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 6058.515157 ms
;;; Empirical mean: 22.99262443712936
;;; Empirical variance: 21.2320788895748
;;; Empirical std: 4.607828001301134
;;; Empirical skewness: -1.5210902177201753
;;; Empirical kurtosis: 5.369820651954278
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 6157.103978 ms
;;; Empirical mean: 20.52817498342859
;;; Empirical variance: 63.90830694889998
;;; Empirical std: 7.994267130193985
;;; Empirical skewness: -0.4178320482570822
;;; Empirical kurtosis: 2.150831554248923
;;; 
;;; Method :importance with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 6035.354752 ms
;;; Empirical mean: 22.00219029742262
;;; Empirical variance: 0.16678579201988344
;;; Empirical std: 0.40839416256832495
;;; Empirical skewness: -11.886058490346851
;;; Empirical kurtosis: 625.1443622961781
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 3972.712587 ms
;;; Empirical mean: 6.1936
;;; Empirical variance: 5.492519040000001
;;; Empirical std: 2.343612391160279
;;; Empirical skewness: 0.21048927676331156
;;; Empirical kurtosis: 2.3684080311242686
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 4033.311755 ms
;;; Empirical mean: 22.48180000000001
;;; Empirical variance: 7.539868760000012
;;; Empirical std: 2.7458821460507026
;;; Empirical skewness: 1.4351439248459426
;;; Empirical kurtosis: 5.929919832043169
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 4015.406793 ms
;;; Empirical mean: 26.266100000000005
;;; Empirical variance: 20.195690789999997
;;; Empirical std: 4.493961591958703
;;; Empirical skewness: 0.4046868720204191
;;; Empirical kurtosis: 1.8074553863491527
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 4080.568603 ms
;;; Empirical mean: 25.62230000000001
;;; Empirical variance: 18.335042710000007
;;; Empirical std: 4.281943800425224
;;; Empirical skewness: 0.24343281694207647
;;; Empirical kurtosis: 2.9527790249812673
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 4112.805564 ms
;;; Empirical mean: 26.958099999999995
;;; Empirical variance: 21.28634439
;;; Empirical std: 4.613712647098863
;;; Empirical skewness: -0.3172388349093304
;;; Empirical kurtosis: 3.963193675328444
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 4188.278317 ms
;;; Empirical mean: 25.363200000000006
;;; Empirical variance: 9.928885760000004
;;; Empirical std: 3.151013449669805
;;; Empirical skewness: -0.9157315424171071
;;; Empirical kurtosis: 4.954624357881706
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 4059.317373 ms
;;; Empirical mean: 26.947899999999997
;;; Empirical variance: 9.457185590000014
;;; Empirical std: 3.075253744002276
;;; Empirical skewness: -0.3923908875081314
;;; Empirical kurtosis: 2.510198190764394
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 3940.008606 ms
;;; Empirical mean: 24.862600000000004
;;; Empirical variance: 8.261121240000028
;;; Empirical std: 2.8742166306665244
;;; Empirical skewness: 1.6512892477870016
;;; Empirical kurtosis: 6.807181405460955
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 3987.009639 ms
;;; Empirical mean: 23.4067
;;; Empirical variance: 4.150495110000001
;;; Empirical std: 2.037276395092232
;;; Empirical skewness: 2.8414199306091628
;;; Empirical kurtosis: 15.24917750322175
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 3933.254528 ms
;;; Empirical mean: 26.195
;;; Empirical variance: 14.865974999999999
;;; Empirical std: 3.8556419698929516
;;; Empirical skewness: -0.5220851110791239
;;; Empirical kurtosis: 3.01426712924439
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 4009.441259 ms
;;; Empirical mean: 6.339100000000002
;;; Empirical variance: 6.84371119
;;; Empirical std: 2.616048774392404
;;; Empirical skewness: 0.5798983540660053
;;; Empirical kurtosis: 2.8351497768911056
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 3972.935906 ms
;;; Empirical mean: 6.805200000000002
;;; Empirical variance: 15.103852959999992
;;; Empirical std: 3.8863675791154897
;;; Empirical skewness: 1.5404877769426968
;;; Empirical kurtosis: 5.219956114365794
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 4040.203092 ms
;;; Empirical mean: 5.715199999999999
;;; Empirical variance: 4.943688959999999
;;; Empirical std: 2.2234407930052913
;;; Empirical skewness: 0.5086597910665195
;;; Empirical kurtosis: 2.6984129630393188
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 3914.238913 ms
;;; Empirical mean: 26.2596
;;; Empirical variance: 18.46620784000001
;;; Empirical std: 4.297232579230499
;;; Empirical skewness: -0.544123809653915
;;; Empirical kurtosis: 1.8765631991431255
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 3931.436619 ms
;;; Empirical mean: 23.7698
;;; Empirical variance: 28.204207960000037
;;; Empirical std: 5.310763406516998
;;; Empirical skewness: 1.3135018510293426
;;; Empirical kurtosis: 4.69283746983351
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 4080.403686 ms
;;; Empirical mean: 5.243
;;; Empirical variance: 4.373551000000001
;;; Empirical std: 2.0913036603994173
;;; Empirical skewness: 0.007624009119081355
;;; Empirical kurtosis: 2.5530919228049704
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 4002.946013 ms
;;; Empirical mean: 24.819
;;; Empirical variance: 21.011438999999996
;;; Empirical std: 4.583823622261223
;;; Empirical skewness: -0.09955962041152246
;;; Empirical kurtosis: 2.2381212857002133
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 4054.572126 ms
;;; Empirical mean: 7.0001999999999995
;;; Empirical variance: 7.134799959999995
;;; Empirical std: 2.6711046329187473
;;; Empirical skewness: 0.7249063968233885
;;; Empirical kurtosis: 3.432544436505368
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 4042.312752 ms
;;; Empirical mean: 7.363599999999997
;;; Empirical variance: 12.774395039999987
;;; Empirical std: 3.5741285707148234
;;; Empirical skewness: 0.9305147694954428
;;; Empirical kurtosis: 3.9236737899050893
;;; 
;;; Method :lmh with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 4064.636903 ms
;;; Empirical mean: 24.00139999999999
;;; Empirical variance: 9.640798039999993
;;; Empirical std: 3.1049634522808787
;;; Empirical skewness: 0.04120716342210457
;;; Empirical kurtosis: 3.193981612596979
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 4513.922107 ms
;;; Empirical mean: 25.269
;;; Empirical variance: 15.874839000000001
;;; Empirical std: 3.984324158499155
;;; Empirical skewness: 0.2727083355848322
;;; Empirical kurtosis: 2.563192229147196
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 4743.179691 ms
;;; Empirical mean: 6.648599999999998
;;; Empirical variance: 8.60171804
;;; Empirical std: 2.9328685684837636
;;; Empirical skewness: 0.5894678358741036
;;; Empirical kurtosis: 3.094350068845788
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 4744.717384 ms
;;; Empirical mean: 24.2412
;;; Empirical variance: 19.651822559999992
;;; Empirical std: 4.433037622217975
;;; Empirical skewness: 0.6021436340641602
;;; Empirical kurtosis: 2.5545355664270346
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 4426.800275 ms
;;; Empirical mean: 8.730999999999998
;;; Empirical variance: 46.77283899999998
;;; Empirical std: 6.839067114745986
;;; Empirical skewness: 1.857832760902818
;;; Empirical kurtosis: 5.439325218427661
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 4493.846368 ms
;;; Empirical mean: 23.044499999999996
;;; Empirical variance: 10.571719749999994
;;; Empirical std: 3.2514181136851645
;;; Empirical skewness: 0.23974828649091823
;;; Empirical kurtosis: 2.2795592474021467
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 4401.888625 ms
;;; Empirical mean: 22.3648
;;; Empirical variance: 18.45312096
;;; Empirical std: 4.295709599123293
;;; Empirical skewness: 0.3844638069986238
;;; Empirical kurtosis: 2.9496094294698647
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 4649.252296 ms
;;; Empirical mean: 5.6268
;;; Empirical variance: 5.571721760000002
;;; Empirical std: 2.3604494826197833
;;; Empirical skewness: 0.3588322431567678
;;; Empirical kurtosis: 2.814591804937996
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 5053.12428 ms
;;; Empirical mean: 10.374200000000002
;;; Empirical variance: 54.26497436000002
;;; Empirical std: 7.366476386984487
;;; Empirical skewness: 1.4342672046879732
;;; Empirical kurtosis: 4.2550726604434805
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 4918.783149 ms
;;; Empirical mean: 19.004600000000003
;;; Empirical variance: 84.81217884000006
;;; Empirical std: 9.20935279159182
;;; Empirical skewness: -0.6753845349432418
;;; Empirical kurtosis: 1.9188581405835614
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 4500.40905 ms
;;; Empirical mean: 27.177999999999997
;;; Empirical variance: 29.670715999999985
;;; Empirical std: 5.447083256202349
;;; Empirical skewness: 0.7273495040675825
;;; Empirical kurtosis: 2.2409429712038222
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 4506.772044 ms
;;; Empirical mean: 26.1594
;;; Empirical variance: 12.572591640000002
;;; Empirical std: 3.5457850527069463
;;; Empirical skewness: -0.32295553781531056
;;; Empirical kurtosis: 2.746374325797958
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 4719.631298 ms
;;; Empirical mean: 26.184399999999993
;;; Empirical variance: 26.78979663999998
;;; Empirical std: 5.175886072934757
;;; Empirical skewness: 0.7774923342750832
;;; Empirical kurtosis: 2.9196820168380473
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 5282.407943 ms
;;; Empirical mean: 16.223800000000004
;;; Empirical variance: 101.38251356000002
;;; Empirical std: 10.068888397434943
;;; Empirical skewness: 0.20556766932789086
;;; Empirical kurtosis: 1.6578108536664242
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 5569.07853 ms
;;; Empirical mean: 27.418699999999998
;;; Empirical variance: 53.396390309999965
;;; Empirical std: 7.3072833741411705
;;; Empirical skewness: 0.3408437671253573
;;; Empirical kurtosis: 2.125994367196857
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 4810.0544 ms
;;; Empirical mean: 10.484499999999999
;;; Empirical variance: 70.03275975
;;; Empirical std: 8.368557805858785
;;; Empirical skewness: 0.9271008359613832
;;; Empirical kurtosis: 2.234999053613898
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 4994.875773 ms
;;; Empirical mean: 6.3655
;;; Empirical variance: 7.62630975
;;; Empirical std: 2.761577402500245
;;; Empirical skewness: 0.4585531105073796
;;; Empirical kurtosis: 2.4504577812774437
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 4978.380675 ms
;;; Empirical mean: 23.436000000000003
;;; Empirical variance: 8.333103999999999
;;; Empirical std: 2.8867116239763195
;;; Empirical skewness: 0.05286235441038435
;;; Empirical kurtosis: 2.057072912311117
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 5401.760261 ms
;;; Empirical mean: 8.626199999999999
;;; Empirical variance: 23.87687356000001
;;; Empirical std: 4.886396786999599
;;; Empirical skewness: 1.2331451067295554
;;; Empirical kurtosis: 4.200083761045321
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 4519.698242 ms
;;; Empirical mean: 5.541000000000001
;;; Empirical variance: 5.132919000000002
;;; Empirical std: 2.2655946239343
;;; Empirical skewness: 0.8060745032409046
;;; Empirical kurtosis: 3.0848499415909596
;;; 
;;; Method :rmh with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 4507.603698 ms
;;; Empirical mean: 7.036700000000001
;;; Empirical variance: 6.052753110000002
;;; Empirical std: 2.4602343607876063
;;; Empirical skewness: 0.1344313176641433
;;; Empirical kurtosis: 2.5544648057597232
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 10109.2721 ms
;;; Empirical mean: 18.720104258018885
;;; Empirical variance: 4.235534261044466
;;; Empirical std: 2.0580413652413467
;;; Empirical skewness: -3.128331602999011
;;; Empirical kurtosis: 20.766356111794977
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 9958.775349 ms
;;; Empirical mean: 22.297777633801623
;;; Empirical variance: 8.062211115961826
;;; Empirical std: 2.8394033028018097
;;; Empirical skewness: -4.0357004797277805
;;; Empirical kurtosis: 21.68968260392152
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 9996.48312 ms
;;; Empirical mean: 24.965086973832506
;;; Empirical variance: 26.101008621671287
;;; Empirical std: 5.1089146226641216
;;; Empirical skewness: -2.443218325157923
;;; Empirical kurtosis: 9.531812758862193
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 11704.215546 ms
;;; Empirical mean: 13.84061398919671
;;; Empirical variance: 56.27176328893871
;;; Empirical std: 7.50145074561839
;;; Empirical skewness: 0.8032338305048518
;;; Empirical kurtosis: 2.389475407289722
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 10604.70753 ms
;;; Empirical mean: 14.390454876774946
;;; Empirical variance: 23.848525727187468
;;; Empirical std: 4.883495236732341
;;; Empirical skewness: -0.5475451072876549
;;; Empirical kurtosis: 2.331559374428268
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 11269.48933 ms
;;; Empirical mean: 17.975411687372656
;;; Empirical variance: 3.9800191648969983
;;; Empirical std: 1.994998537567634
;;; Empirical skewness: -1.0036735864441444
;;; Empirical kurtosis: 23.39853326767084
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 11277.828257 ms
;;; Empirical mean: 11.967094335593034
;;; Empirical variance: 79.98509230456544
;;; Empirical std: 8.94343850566243
;;; Empirical skewness: 0.8118988235416429
;;; Empirical kurtosis: 2.1805755131644378
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 10707.73114 ms
;;; Empirical mean: 11.781249472235137
;;; Empirical variance: 31.2188595241389
;;; Empirical std: 5.587383960686691
;;; Empirical skewness: 1.142628931003031
;;; Empirical kurtosis: 4.237314494670057
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 11098.808944 ms
;;; Empirical mean: 24.629412106902446
;;; Empirical variance: 68.89253134850382
;;; Empirical std: 8.30015248947294
;;; Empirical skewness: 0.47946986624970644
;;; Empirical kurtosis: 2.8655665663748953
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 10171.528826 ms
;;; Empirical mean: 20.387028037904226
;;; Empirical variance: 13.332104995644697
;;; Empirical std: 3.6513155157620516
;;; Empirical skewness: -2.3677426872489318
;;; Empirical kurtosis: 9.544196046665048
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 9782.503139 ms
;;; Empirical mean: 20.739392176731325
;;; Empirical variance: 96.34952053171186
;;; Empirical std: 9.815779160704048
;;; Empirical skewness: 0.47663609780564203
;;; Empirical kurtosis: 2.300323193564215
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 9572.400867 ms
;;; Empirical mean: 20.22999946227142
;;; Empirical variance: 58.35365506242751
;;; Empirical std: 7.638956411868541
;;; Empirical skewness: -0.4058032839029952
;;; Empirical kurtosis: 1.8795293573290306
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 9567.995022 ms
;;; Empirical mean: 18.911953471854343
;;; Empirical variance: 49.22366704040417
;;; Empirical std: 7.015958027269274
;;; Empirical skewness: 0.028787381688355217
;;; Empirical kurtosis: 1.7375631875720285
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 9441.870041 ms
;;; Empirical mean: 20.810904188198098
;;; Empirical variance: 26.878641466925934
;;; Empirical std: 5.184461540693106
;;; Empirical skewness: -0.8889903298881257
;;; Empirical kurtosis: 3.73557317109681
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 9883.322908 ms
;;; Empirical mean: 22.081353284132383
;;; Empirical variance: 19.79618081167878
;;; Empirical std: 4.449289922187448
;;; Empirical skewness: -1.524021483373337
;;; Empirical kurtosis: 7.927931937523029
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 10321.869305 ms
;;; Empirical mean: 20.252063193905133
;;; Empirical variance: 29.766696395817466
;;; Empirical std: 5.4558863987272925
;;; Empirical skewness: -0.7358193087199825
;;; Empirical kurtosis: 3.161691975751062
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 9933.781177 ms
;;; Empirical mean: 25.44185967155985
;;; Empirical variance: 43.69298405893693
;;; Empirical std: 6.610066872501134
;;; Empirical skewness: -1.7016925078737566
;;; Empirical kurtosis: 5.297089946584492
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 11548.773499 ms
;;; Empirical mean: 24.20776447190632
;;; Empirical variance: 12.041870650565675
;;; Empirical std: 3.4701398603753244
;;; Empirical skewness: -0.2842657407126956
;;; Empirical kurtosis: 7.600989460438674
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 10740.112787 ms
;;; Empirical mean: 21.653795397951924
;;; Empirical variance: 20.374598484368267
;;; Empirical std: 4.513823045309626
;;; Empirical skewness: -1.4006732170906835
;;; Empirical kurtosis: 6.681837751723294
;;; 
;;; Method :smc with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 9924.198721 ms
;;; Empirical mean: 19.43750998563823
;;; Empirical variance: 56.75877133265669
;;; Empirical std: 7.533841737961894
;;; Empirical skewness: -0.6047770126485909
;;; Empirical kurtosis: 2.6933926436499833
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 0
;;; Elapsed time: 6943.138257 ms
;;; Empirical mean: 23.94784397351066
;;; Empirical variance: 49.684219476031004
;;; Empirical std: 7.04870338970445
;;; Empirical skewness: -1.2486575078914421
;;; Empirical kurtosis: 4.723315156485869
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 1
;;; Elapsed time: 7247.526609 ms
;;; Empirical mean: 23.60090614354916
;;; Empirical variance: 48.35052749318515
;;; Empirical std: 6.953454356877964
;;; Empirical skewness: -1.3176656633891068
;;; Empirical kurtosis: 4.994412341021969
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 2
;;; Elapsed time: 7600.442744 ms
;;; Empirical mean: 24.574125905651357
;;; Empirical variance: 26.477592531980513
;;; Empirical std: 5.145638204536004
;;; Empirical skewness: -0.8530025861315114
;;; Empirical kurtosis: 5.529628290383534
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 3
;;; Elapsed time: 7271.497175 ms
;;; Empirical mean: 23.643775329415515
;;; Empirical variance: 39.93198672167265
;;; Empirical std: 6.319176110987306
;;; Empirical skewness: -1.3590659334660211
;;; Empirical kurtosis: 5.660090216561922
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 4
;;; Elapsed time: 6941.671836 ms
;;; Empirical mean: 23.736125278456008
;;; Empirical variance: 36.596663029589315
;;; Empirical std: 6.049517586517896
;;; Empirical skewness: -1.0802032601139369
;;; Empirical kurtosis: 5.0844257972461415
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 5
;;; Elapsed time: 6848.544895 ms
;;; Empirical mean: 23.919636084516455
;;; Empirical variance: 43.91303750131069
;;; Empirical std: 6.626691293648037
;;; Empirical skewness: -1.3668503988278131
;;; Empirical kurtosis: 5.22509397229509
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 6
;;; Elapsed time: 6769.519719 ms
;;; Empirical mean: 23.68731730358476
;;; Empirical variance: 40.95985406602674
;;; Empirical std: 6.399988598898184
;;; Empirical skewness: -1.2824391813240401
;;; Empirical kurtosis: 5.629619416453126
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 7
;;; Elapsed time: 7673.832773 ms
;;; Empirical mean: 23.381876844584095
;;; Empirical variance: 45.302770178015344
;;; Empirical std: 6.730733257083907
;;; Empirical skewness: -1.04441381333016
;;; Empirical kurtosis: 4.699715303575475
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 8
;;; Elapsed time: 6794.965769 ms
;;; Empirical mean: 23.892266811504516
;;; Empirical variance: 38.21871167214431
;;; Empirical std: 6.1821284095483096
;;; Empirical skewness: -1.2769661388489641
;;; Empirical kurtosis: 5.41818822142888
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 9
;;; Elapsed time: 7054.18073 ms
;;; Empirical mean: 22.955016798507447
;;; Empirical variance: 47.68319288601576
;;; Empirical std: 6.9053017954334015
;;; Empirical skewness: -1.0625176258981
;;; Empirical kurtosis: 4.573829655836211
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 10
;;; Elapsed time: 7196.646777 ms
;;; Empirical mean: 24.065211961549075
;;; Empirical variance: 45.07894181135873
;;; Empirical std: 6.7140853294666085
;;; Empirical skewness: -1.1273938243192965
;;; Empirical kurtosis: 4.883928534889421
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 11
;;; Elapsed time: 6913.267821 ms
;;; Empirical mean: 23.486841887131735
;;; Empirical variance: 47.301694828718176
;;; Empirical std: 6.877622759988961
;;; Empirical skewness: -1.1473486407168263
;;; Empirical kurtosis: 4.757200380803051
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 12
;;; Elapsed time: 6767.382003 ms
;;; Empirical mean: 24.136700404404117
;;; Empirical variance: 39.22874904838545
;;; Empirical std: 6.263285802866212
;;; Empirical skewness: -1.2725403086285914
;;; Empirical kurtosis: 5.222180150559112
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 13
;;; Elapsed time: 7004.758945 ms
;;; Empirical mean: 22.61928983894333
;;; Empirical variance: 54.38847355172398
;;; Empirical std: 7.374854137657502
;;; Empirical skewness: -0.9509879330296228
;;; Empirical kurtosis: 3.9079193969301804
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 14
;;; Elapsed time: 7781.373609 ms
;;; Empirical mean: 23.327535598575682
;;; Empirical variance: 43.80559083120846
;;; Empirical std: 6.618579215451641
;;; Empirical skewness: -1.148326314131482
;;; Empirical kurtosis: 4.764048098166174
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 15
;;; Elapsed time: 7179.259348 ms
;;; Empirical mean: 23.802248551302007
;;; Empirical variance: 30.10200629577938
;;; Empirical std: 5.486529531113396
;;; Empirical skewness: -0.7093719210213432
;;; Empirical kurtosis: 5.176096175659611
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 16
;;; Elapsed time: 7496.641903 ms
;;; Empirical mean: 23.478899760217637
;;; Empirical variance: 34.77710610663188
;;; Empirical std: 5.897211723063017
;;; Empirical skewness: -1.3637290488572154
;;; Empirical kurtosis: 6.3610422155850745
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 17
;;; Elapsed time: 6658.438893 ms
;;; Empirical mean: 24.091472056755496
;;; Empirical variance: 37.669217329982374
;;; Empirical std: 6.1375253425124345
;;; Empirical skewness: -0.9969890499174265
;;; Empirical kurtosis: 5.177160240080954
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 18
;;; Elapsed time: 6615.058423 ms
;;; Empirical mean: 24.31182625711904
;;; Empirical variance: 37.64518873468386
;;; Empirical std: 6.13556751529016
;;; Empirical skewness: -1.1819689896503967
;;; Empirical kurtosis: 5.257014933553501
;;; 
;;; Method :smc with 10000 samples and options [:number-of-particles 100]
;;; Chain no. 19
;;; Elapsed time: 6659.450319 ms
;;; Empirical mean: 23.43340023798156
;;; Empirical variance: 31.383421328319034
;;; Empirical std: 5.602090799721032
;;; Empirical skewness: -1.490761758817859
;;; Empirical kurtosis: 7.062105461917175
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 7524.243112 ms
;;; Empirical mean: 19.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 7281.30194 ms
;;; Empirical mean: 6.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 7118.325516 ms
;;; Empirical mean: 31.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 7123.630464 ms
;;; Empirical mean: 4.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 7014.066951 ms
;;; Empirical mean: 2.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 6997.747173 ms
;;; Empirical mean: 21.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 6974.644021 ms
;;; Empirical mean: 15.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 7918.823673 ms
;;; Empirical mean: 6.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 8743.689225 ms
;;; Empirical mean: 9.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 10283.276114 ms
;;; Empirical mean: 12.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 7680.023619 ms
;;; Empirical mean: 13.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 7334.274985 ms
;;; Empirical mean: 2.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 7146.679785 ms
;;; Empirical mean: 11.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 7539.648167 ms
;;; Empirical mean: 12.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 6777.242757 ms
;;; Empirical mean: 21.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 7138.004345 ms
;;; Empirical mean: 7.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 7083.221607 ms
;;; Empirical mean: 7.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 8420.122213 ms
;;; Empirical mean: 15.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 7950.02266 ms
;;; Empirical mean: 26.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :pgibbs with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 7663.415206 ms
;;; Empirical mean: 12.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 0
;;; Elapsed time: 2296.175663 ms
;;; Empirical mean: 14.174819891483537
;;; Empirical variance: 54.94927974255369
;;; Empirical std: 7.412778139304703
;;; Empirical skewness: 0.2291549742224479
;;; Empirical kurtosis: 2.02368331183551
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 1
;;; Elapsed time: 2335.469501 ms
;;; Empirical mean: 14.903159015263608
;;; Empirical variance: 62.960655417214014
;;; Empirical std: 7.9347750703604705
;;; Empirical skewness: 0.2155889968546029
;;; Empirical kurtosis: 2.1849470377690468
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 2
;;; Elapsed time: 2270.315408 ms
;;; Empirical mean: 17.063021917049053
;;; Empirical variance: 49.93818816880987
;;; Empirical std: 7.066695703708337
;;; Empirical skewness: 0.7569554343273328
;;; Empirical kurtosis: 2.664429914940342
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 3
;;; Elapsed time: 2258.825941 ms
;;; Empirical mean: 14.34573070940333
;;; Empirical variance: 54.4848581163094
;;; Empirical std: 7.38138592110651
;;; Empirical skewness: 0.3880060386317543
;;; Empirical kurtosis: 2.463787358467862
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 4
;;; Elapsed time: 2490.936864 ms
;;; Empirical mean: 17.4380687942241
;;; Empirical variance: 147.14263758401356
;;; Empirical std: 12.130236501569685
;;; Empirical skewness: 0.9899772056729715
;;; Empirical kurtosis: 2.8203341478033987
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 5
;;; Elapsed time: 2761.509219 ms
;;; Empirical mean: 15.562866294072007
;;; Empirical variance: 34.24657670175406
;;; Empirical std: 5.852057475944171
;;; Empirical skewness: -0.18728519391626544
;;; Empirical kurtosis: 1.6288705648851476
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 6
;;; Elapsed time: 2939.611449 ms
;;; Empirical mean: 16.195996202183405
;;; Empirical variance: 46.199685969782486
;;; Empirical std: 6.79703508669644
;;; Empirical skewness: 0.1917466385012018
;;; Empirical kurtosis: 2.3198853136058966
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 7
;;; Elapsed time: 2644.80575 ms
;;; Empirical mean: 18.734286206819895
;;; Empirical variance: 37.3041838584746
;;; Empirical std: 6.107715109472167
;;; Empirical skewness: 0.7721875048678923
;;; Empirical kurtosis: 2.778221239295445
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 8
;;; Elapsed time: 2410.676579 ms
;;; Empirical mean: 14.668068468304252
;;; Empirical variance: 58.21118545400467
;;; Empirical std: 7.629625512042165
;;; Empirical skewness: 1.1845314811572287
;;; Empirical kurtosis: 4.014773229135219
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 9
;;; Elapsed time: 2478.883438 ms
;;; Empirical mean: 20.81203206763673
;;; Empirical variance: 113.02292336293252
;;; Empirical std: 10.631223982351822
;;; Empirical skewness: 0.5983591702081964
;;; Empirical kurtosis: 2.5018744021781263
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 10
;;; Elapsed time: 2517.388602 ms
;;; Empirical mean: 16.567921089460036
;;; Empirical variance: 48.55918504984274
;;; Empirical std: 6.9684420819751915
;;; Empirical skewness: 0.18618148790791747
;;; Empirical kurtosis: 2.91502510763361
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 11
;;; Elapsed time: 2628.215091 ms
;;; Empirical mean: 16.68898737374623
;;; Empirical variance: 107.96758460180735
;;; Empirical std: 10.390745141798414
;;; Empirical skewness: 1.2165251093269656
;;; Empirical kurtosis: 3.9505041989517675
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 12
;;; Elapsed time: 2937.463698 ms
;;; Empirical mean: 15.005060984853184
;;; Empirical variance: 36.425428100816156
;;; Empirical std: 6.035348217030742
;;; Empirical skewness: 1.0169799198601266
;;; Empirical kurtosis: 2.731989572814509
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 13
;;; Elapsed time: 2897.739312 ms
;;; Empirical mean: 13.811406519319515
;;; Empirical variance: 45.486514864267725
;;; Empirical std: 6.744369122776995
;;; Empirical skewness: 1.1724676877835085
;;; Empirical kurtosis: 3.949162260487557
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 14
;;; Elapsed time: 2713.01607 ms
;;; Empirical mean: 15.174777791759098
;;; Empirical variance: 88.85356953128395
;;; Empirical std: 9.426217137923567
;;; Empirical skewness: 1.310274444885214
;;; Empirical kurtosis: 3.894949300046004
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 15
;;; Elapsed time: 2476.443361 ms
;;; Empirical mean: 14.80784924931686
;;; Empirical variance: 72.37982386709521
;;; Empirical std: 8.507633270604417
;;; Empirical skewness: 0.429309377711924
;;; Empirical kurtosis: 2.5778869893895244
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 16
;;; Elapsed time: 2484.635434 ms
;;; Empirical mean: 14.125053710043193
;;; Empirical variance: 21.10989087796952
;;; Empirical std: 4.594550127919981
;;; Empirical skewness: 0.9829751925350995
;;; Empirical kurtosis: 3.5027512416235727
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 17
;;; Elapsed time: 2544.008374 ms
;;; Empirical mean: 11.981119701659694
;;; Empirical variance: 44.12137019051231
;;; Empirical std: 6.642391902809734
;;; Empirical skewness: 0.827354822440349
;;; Empirical kurtosis: 3.0561216671689673
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 18
;;; Elapsed time: 2964.543426 ms
;;; Empirical mean: 13.427170612952692
;;; Empirical variance: 54.171835319465565
;;; Empirical std: 7.3601518543753945
;;; Empirical skewness: 0.6694113969139814
;;; Empirical kurtosis: 3.605316351546697
;;; 
;;; Method :ipmcmc with 10000 samples and options []
;;; Chain no. 19
;;; Elapsed time: 2585.834911 ms
;;; Empirical mean: 17.187496593762518
;;; Empirical variance: 60.15131287447918
;;; Empirical std: 7.75572774628398
;;; Empirical skewness: 0.9326177717782993
;;; Empirical kurtosis: 2.6105470249939473
;;; 
;; <-
;; =>
;;; {"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x62633ebb]</span>","value":"#multifn[print-method 0x62633ebb]"}],"value":"[nil,#multifn[print-method 0x62633ebb]]"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x62633ebb]</span>","value":"#multifn[print-method 0x62633ebb]"}],"value":"[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model</span>","value":"#'model/model"}],"value":"[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model_name</span>","value":"#'model/model_name"}],"value":"[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/outfile</span>","value":"#'model/outfile"}],"value":"[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/configurations</span>","value":"#'model/configurations"}],"value":"[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num_samples_options</span>","value":"#'model/num_samples_options"}],"value":"[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/thinning</span>","value":"#'model/thinning"}],"value":"[[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num-chains</span>","value":"#'model/num-chains"}],"value":"[[[[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil],#'model/num-chains]"},{"type":"list-like","open":"<span class='clj-lazy-seq'>(</span>","close":"<span class='clj-lazy-seq'>)</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"(nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil)"}],"value":"[[[[[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil],#'model/num-chains],(nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil)]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[[[[nil,#multifn[print-method 0x62633ebb]],#multifn[print-method 0x62633ebb]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil],#'model/num-chains],(nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil)],nil]"}
;; <=

;; @@

;; @@
