;; gorilla-repl.fileformat = 1

;; **
;;; # Gorilla REPL
;;; 
;;; Welcome to gorilla :-)
;;; 
;;; Shift + enter evaluates code. Hit alt+g twice in quick succession or click the menu icon (upper-right corner) for more commands ...
;;; 
;;; It's a good habit to run each worksheet in its own namespace: feel free to use the declaration we've provided below if you'd like.
;; **

;; @@
(ns model
  (:require [gorilla-plot.core :as plot])
  (:use [anglican core emit runtime stat
          [state :only [get-predicts get-log-weight get-result]]]))

(defdist geometric
"Geometric distribution on support {0,1,2....}"
[p] []
(sample* [this]
        (loop [value 0]
            (if (sample* (flip p))
            value
            (recur (inc value)))))
(observe* [this value] (+ (log p) (* value (log (- 1 p))))))

(defdist dirac [x]
    (sample* [this] x)
    (observe* [this value]
              (if (= value x)
                0
                (- (/ 1.0 0.0)))))


(with-primitive-procedures [dirac geometric]
  (defquery nested0 [ a b]
    (let [_unused (observe (if (= (* 1 b) 0) (dirac 0) (poisson (* 1 b))) 5)
         ]
      [ a b ]
    )

  )
  (defquery model
    (let [[ a b] [ 0 0 ]
          [ a b]
          (let [a (+ 0 0)
                b (sample (bernoulli 0.5))
                b (+ (* 5 b) 5)
                [ a b] (sample ((conditional nested0)  a b))

               ]
            [ a b ]
          )
         ]
    b
    )
  )

(def model_name "test")
(def outfile "test_anglican.json")

(def method :lmh)
(def num_samples 10000)
(def thinning 1)
(def warmup (/ num_samples 5))

(spit outfile (format "[\n" method num_samples) :append false)

(def num-runs 3)

(doall
  (for [chain (range 0 num-runs)]
    (do
      (println (format "\nChain no. %s" chain))
      (let [start (. System (nanoTime))
            samples (take-nth thinning (take (* num_samples thinning) (drop warmup (doquery method model []))))
            results (collect-results samples)
            end (. System (nanoTime))
            elapsed_ms (/ (- end start) 1e6)
            values (map (fn [s] (get-result s)) samples)
            max-value (apply max values)
            mean (empirical-mean results)
            variance (empirical-variance results)
            std (empirical-std results)
            skewness 0.0; (empirical-skew results)
            kurtosis 0.0; (empirical-kurtosis results)
            distribution (empirical-distribution (collect-results samples))
            masses (for [n (range 0 (inc max-value))] (get distribution n 0.0))]
        (println (format "Elapsed time: %s ms" elapsed_ms))
        (println (format "Empirical mean: %s" mean))
        (println (format "Empirical variance: %s" variance))
        (println (format "Empirical std: %s" std))
        (println (format "Empirical skewness: %s" skewness))
        (println (format "Empirical kurtosis: %s" kurtosis))
        (spit outfile (format
                   "{\"model\": \"%s\", \"system\": \"anglican\", \"method\": \"%s\", \"num_samples\": %s, \"time_ms\": %s, \"total\": 1.0, \"mean\": %s, \"variance\": %s, \"stddev\": %s, \"skewness\": %s, \"kurtosis\": %s, \"masses\": [%s] },\n"
                   model_name method num_samples elapsed_ms mean variance std skewness kurtosis
                   (clojure.string/join ", " masses)) :append true)
        (println "Empirical distribution:")
        (doall (for [n (range 0 (inc max-value))]
            (println (format "p(%s) = %s" n (get distribution n 0.0)))))
        (println "List of samples (format: sample log-weight):")
        ; (doall (map (fn [s] (println (format "%s %s" (get-result s) (get-log-weight s)))) samples))
        ; values need to be adjusted if they are weighted!
        ; (plot/histogram values :normalize :probability)
      )
    )
  )
)

(spit outfile "]\n" :append true)

;; @@
;; ->
;;; 
;;; Chain no. 0
;;; Elapsed time: 825.944189 ms
;;; Empirical mean: 3.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: 0.0
;;; Empirical kurtosis: 0.0
;;; Empirical distribution:
;;; p(0) = 0.0
;;; p(1) = 0.0
;;; p(2) = 0.0
;;; p(3) = 1.0
;;; List of samples (format: sample log-weight):
;;; 
;;; Chain no. 1
;;; Elapsed time: 836.811356 ms
;;; Empirical mean: 3.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: 0.0
;;; Empirical kurtosis: 0.0
;;; Empirical distribution:
;;; p(0) = 0.0
;;; p(1) = 0.0
;;; p(2) = 0.0
;;; p(3) = 1.0
;;; List of samples (format: sample log-weight):
;;; 
;;; Chain no. 2
;;; Elapsed time: 777.560837 ms
;;; Empirical mean: 3.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: 0.0
;;; Empirical kurtosis: 0.0
;;; Empirical distribution:
;;; p(0) = 0.0
;;; p(1) = 0.0
;;; p(2) = 0.0
;;; p(3) = 1.0
;;; List of samples (format: sample log-weight):
;;; 
;; <-
;; =>
;;; {"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x54db6428]</span>","value":"#multifn[print-method 0x54db6428]"}],"value":"[nil,#multifn[print-method 0x54db6428]]"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x54db6428]</span>","value":"#multifn[print-method 0x54db6428]"}],"value":"[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model</span>","value":"#'model/model"}],"value":"[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model_name</span>","value":"#'model/model_name"}],"value":"[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/outfile</span>","value":"#'model/outfile"}],"value":"[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/method</span>","value":"#'model/method"}],"value":"[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num_samples</span>","value":"#'model/num_samples"}],"value":"[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/thinning</span>","value":"#'model/thinning"}],"value":"[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/warmup</span>","value":"#'model/warmup"}],"value":"[[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning],#'model/warmup]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning],#'model/warmup],nil]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num-runs</span>","value":"#'model/num-runs"}],"value":"[[[[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning],#'model/warmup],nil],#'model/num-runs]"},{"type":"list-like","open":"<span class='clj-lazy-seq'>(</span>","close":"<span class='clj-lazy-seq'>)</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"(nil nil nil)"}],"value":"[[[[[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning],#'model/warmup],nil],#'model/num-runs],(nil nil nil)]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[[[[[nil,#multifn[print-method 0x54db6428]],#multifn[print-method 0x54db6428]],#'model/model],#'model/model_name],#'model/outfile],#'model/method],#'model/num_samples],#'model/thinning],#'model/warmup],nil],#'model/num-runs],(nil nil nil)],nil]"}
;; <=

;; @@

;; @@
