# Guess the Instruction! Flipped Learning Makes Language Models Stronger Zero-Shot Learners 

Paper Link : https://arxiv.org/abs/2210.02969 (accepted at ICLR 2023)

Demo Link : http://flipped-learning-demo.com:8880

Overview of FLIPPED inference, compared to DIRECT and CHANNEL method.
<p align="center">
  <img src="./Flipped_overview.png" width="80%" height="80%">
</p>

## Setting
The following command will clone the project:
```
git clone https://github.com/seonghyeonye/Flipped-Learning.git
```

Before experimenting, you can make a virtual environment for the project.
```
conda create -n zeroshotlm python=3.8
conda activate zeroshotlm
pip install -r requirements.txt
```

## Dataset download
For training and evaluating NLP tasks, we use dataset provided by [Hugging Face Dataset Library](https://github.com/huggingface/datasets). For Story Cloze, the dataset is not automatically provided, so you should fill a google form (http://goo.gl/forms/aQz39sdDrO) to get the dataset. Then you can make a directory named data using 
```
mkdir data
```
under the root directory. Put your downloaded dataset under the data directory in order to proceed the experiment.\
For prompts of NLP tasks, we use toolkit provided by [BigScience](https://github.com/bigscience-workshop/promptsource). They are easily applied to huggingface datasets, which are implemented in our code.\
We also use subset of [BIG-bench](https://github.com/google/BIG-bench) benchmarks for our evaluation.


## Released checkpoints
We recommend using the [FLIPPED-11B](seonghyeonye/flipped_11B) checkpoint as it leads (on average) to the best performances on a variety of NLP tasks.
|Model|Number of parameters|
|-|-|
|[Flipped_11B](https://huggingface.co/seonghyeonye/flipped_11B)|11 billion|
|[Flipped_3B](https://huggingface.co/seonghyeonye/flipped_3B)|3 billion|

Here is how to download the model in PyTorch:

```python
import torch
from transformers import T5Tokenizer, T5ForConditionalGeneration

model = T5ForConditionalGeneration.from_pretrained("seonghyeonye/flipped_11B")
tokenizer = T5Tokenizer.from_pretrained("seonghyeonye/flipped_11B")
```
If you want to use another checkpoint, please replace the path in `T5Tokenizer` and `T5ForConditionalGeneration`.

## Quick start
We provide a quick [Jupyter notebook](./flipped_inference.ipynb) with explanation where you can test the inference of FLIPPED.
## Training&evaluation
We provide commands for all our experiments in README.md under T0 directory. Check [this](./T0/README.md) out!


## Citation
If you find this useful, please consider citing our paper:
```
@article{ye2022guess,
  title={Guess the Instruction! Flipped Learning Makes Language Models Stronger Zero-Shot Learners},
  author={Ye, Seonghyeon and Kim, Doyoung and Jang, Joel and Shin, Joongbo and Seo, Minjoon},
  journal={arXiv preprint arXiv:2210.02969},
  year={2022}
}
```  

