# INSES: Intelligent Navigation & Similarity-Enhanced Search

## Installation
```bash
# Python 3.10+ recommended
pip install -r requirements.txt
# or
pip install -e .
```

### Optional services via Docker
```bash
# Start Qdrant & Neo4j (see docker-compose.yml)
docker compose up -d
```

## Configure API keys & endpoints
Copy `.env.example` to `.env` and edit:
```
OPENAI_API_KEY=sk-...
ZHIPUAI_API_KEY=...
QDRANT_URL=http://localhost:6333
QDRANT_API_KEY=             # if you enabled auth
NEO4J_URI=bolt://localhost:7687
NEO4J_USERNAME=neo4j
NEO4J_PASSWORD=your_password
```

Most classes accept params directly; environment variables are a convenient default.

## Quickstart
Run the demo router over a small sample:
```bash
# Small end-to-end run (defaults to 2wiki, sample_size=50)
python examples/run_router.py --dataset 2wiki --sample-size 1000 --confidence 0.8
```

Or use the console script (after `pip install -e .`):
```bash
inses-demo --dataset 2wiki --sample-size 1000 --confidence 0.8
```

## Datasets
`data/` includes JSON files such as `2wiki.json`, `hotpotqa.json`, `musique.json`.
Each item typically contains fields like `question`, `answer`, and rich context (entities, supporting_facts, evidences).

## Project Layout
```
graphsearch/
  data/                          # demo datasets
  inses/
    data_loader.py
    evaluator.py
    inses_retriever.py
    llmer.py
    llm_factory.py
    neo4j_graphdb.py
    neo4j_manager.py
    qdrant_vectordb.py
    rag_router.py
  results/                       # outputs 
  graphdb_backups/               # Neo4j snapshots 
  examples/
    run_router.py
```
