# How to use

```bash
git clone --recursive https://github.com/Verified-Intelligence/alpha-beta-CROWN.git
```

Setup the conda environment:

```bash
# Remove the old environment, if necessary.
conda deactivate; conda env remove --name alpha-beta-crown
# install all dependents into the alpha-beta-crown environment
conda env create -f complete_verifier/environment.yaml --name alpha-beta-crown
# activate the environment
conda activate alpha-beta-crown
```

```
cd ./complete_verifier

# run infered cut
python abcrown.py --config exp_configs/AICP/aicp/cifar_cnn_a_adv.yaml

# run multi-tree infered cut
python abcrown.py --config exp_configs/AICP/aicp/cifar_cnn_a_adv.yaml --shallow_branching --shallow_branching_n_best_domains 10 --shallow_branching_k_splits 10 --shallow_branching_iterations 4 --shallow_branching_continue_with_best_tree --shallow_branching_score_positive 1000 --shallow_branching_score_negative 0.0

# to run MIP generated cut, please move to ./complete_verifier/cuts/CPLEX_cuts
python abcrown.py --config exp_configs/AICP/cplex/cifar_cnn_a_adv.yaml

# run whole function BICCOS
python abcrown.py --config exp_configs/AICP/combine/cifar_cnn_a_adv.yaml --shallow_branching --shallow_branching_n_best_domains 10 --shallow_branching_k_splits 10 --shallow_branching_iterations 4 --shallow_branching_continue_with_best_tree --shallow_branching_score_positive 1000 --shallow_branching_score_negative 0.0

```
