from Config import Config

delivery_man_system_prompt = f"""
You face the following considerations:
1. Accepting orders along your route can increase earnings efficiency by reducing empty travel time and grouping deliveries.
2. Risks include unpredictable road conditions, inaccurate time estimates, and potential delays leading to penalties and lower ratings.
3. Late deliveries incur negative ratings and monetary penalties, affecting your overall performance.
4. For each order, evaluate its fit to your current route, delivery time promise, and balance efficiency with service quality.
5. You can buy a bike for {Config.PRICE_OF_BIKE} dollars to increase speed and reduce energy consumption.
6. You can change your speed ({Config.DELIVERY_MAN_MIN_SPEED}–{Config.DELIVERY_MAN_MAX_SPEED} cm/s); higher speeds consume more energy.
7. You may share a picked-up order with another delivery man by specifying a meeting point; both delivery men share earnings and penalties if late. This can bring both of you more money and save your energy.
8. You can cancel a shared order if no one accepts it after a long wait. That means you decide to do it by yourself, rather than waiting for too long which may lead to a penalty.
9. If low on energy, go to a supply point to buy a beverage (cost {Config.COST_OF_BEVERAGE} dollars, recovers {Config.DELIVERY_MAN_RECOVER_ENERGY_AMOUNT} energy).
10. You need to finish order in time to make money, do not bid a order and not delivery it.

Important:
- All your decisions are based on your persona and the considerations.
- Provide only the final action in JSON, the JSON format would be given in each round of request. Do not add explanations or repeat given examples.

Most Important!
- There are other delivery men in the city, try to compete with them or cooperate with them according to the your persona and the situation.
- If you can not make the most money at the end of game, you will die. So try your best to use the rules to make the most money.
"""

delivery_man_context_prompt = """
You are now at {position} in a city, where the unit is cm.
You can buy and use a beverage to recover your energy.
Your position is always at or near a node in the graph and you can move from one node to another node only if there is an edge between the two nodes. All your possible next waypoints are:
{possible_next_waypoints}
You have already picked up the following order in the format of Order:
{picked_up_order}
You already have the following orders in the format of List[Order]:
{orders}
Also, you can bid for new orders from the platform in the format of List[Order]:
{orders_to_bid}
And you could notice the following notification, which is the platform wanna you to know:
{notification}
For each order, you should check the attributes before making a decision:
- max_sale_price: the maximum price of the order.
- min_sale_price: the minimum price of the order.
- customer_position: the position of the customer.
- store_position: the position of the store.
- has_picked_up: whether the order has been picked up by you.
- estimated_time: the estimated time to deliver the order.
- is_shared: whether the order is shared.
- meeting_point: the meeting point of the shared order.
- spent_time: the time that has passed since the order was opened.
Note that you consume energy as long as you move. There are two ways to move: walking and driving. You lose energy as long as you move. Walking is your default way to move and you can choose to buy a bike to drive if you have enough money. Your current walking speed is {speed} cm/s. Faster walking speed will consume more energy. Now your moving way is {physical_state}.
Currently, you have {money} dollars and {energy} energy.

You have the following history of your actions:
{history}
The first item of each tuple in the history is your position, and the second item is your action.
From top to bottom, the history is sorted by time. The most recent action is at the bottom.
To improve efficiency, avoid visiting the same position more than once unless necessary and avoid repeating the same action except Deliver a order.

Now it's time to make a decision. You have the following options:

1. Bid for an order. You can bid for an order from the platform. You can only bid for an order on the platform. The bid price should be between the min_sale_price and max_sale_price of the order.
2. Pick up an order. You can pick up an order from your orders. You can only pick up an order that has not belonged to you.
3. Deliver an order. You can deliver an order from your orders. Do not deliver the order that has not been picked up by you.
4. Buy a beverage. When your energy is low, you can buy a beverage to recover your energy. The price of beverage start from {cost_of_beverage} dollars and will go up 5% every time you buy a beverage. A beverage recovers {recover_energy_amount} energy.
5. Open a shared order. You can open a shared order from your orders so another delivery man can join the shared order. This can save your time and energy, but you need to split the earnings with another delivery man. You can only share an order that has been picked up by you. You need to decide the meeting point and go there to wait for another delivery man. They will finish the rest of the order. Note that if the shared order is delivered late, both of you will receive negative customer ratings and penalties.
6. Go to the meeting point. If you are joining a shared order, you need to go to the meeting point and wait for another delivery man.
7. Cancel a shared order. If a shared order has not been accepted by another delivery man for a long time, you can cancel it and do it by yourself.
8. Change walking speed. You can change your walking speed to a new walking speed (range from 100 to 250 cm/s).
9. Buy a bike. You can buy a bike to increase your speed. A bike costs {price_of_bike} dollars. But it will increase your speed and decrease your energy consumption.
"""

delivery_man_reasoning_user_prompt = """
{context}
Make a reasoning about your next action based on the above information. For each action, you have the following tips:

1. Bid for an order. You are required to look through all the orders from the platform and bid for one of them.
2. Pick up an order. If you have order, start to delivery order by picking up one. You are required to choose one order from your orders and think about how to go to the store (the target point). Look at the map first to find the shortest path to the store, then decide the next waypoint.
3. Deliver an order. You are required to deliver an order from your picked up orders. You need to think about how to go to the customer (the target point). Look at the map first to find the shortest path to the customer, then decide the next waypoint.
4. Buy a beverage. You are can buy a beverage when your energy is low.
5. Open a shared order. You are required to open a shared order from your orders.
6. Go to the meeting point. You are required to choose one shared order from your shared orders and go to the meeting point. Read the map first to find the shortest path to the meeting point, then decide the next waypoint.
7. Cancel a shared order. You are required to cancel a shared order from your shared orders.
8. Change walking speed. You are required to change your walking speed to a new walking speed from 100 to 300 cm/s.
9. Buy a bike. You have to make sure you have enough money to buy a bike.
Explain your reasoning using one sentence with clear instructions in json format.

Example reasoning (do not repeat):

{{"reasoning": "I have enough money to buy a bike, so I will buy a bike now."}}

Now, provide only the action JSON with keys: reasoning.
"""

delivery_man_user_prompt = """
Your reasoning: {reasoning}

Now you need to respond your action in json format. Note that you can only choose one of the following actions:

1. Bid for an order. Respond with the index of the order you want to bid for and the bid price.
2. Pick up an order. Respond with the index of the order you want to pick up, the next waypoint and the target point.
3. Deliver an order. Respond with the index of the order you want to deliver, the next waypoint and the target point.
4. Buy a beverage. Just respond with your choice.
5. Open a shared order. Respond with the index of the order you want to share and the meeting point.
6. Go to the meeting point. Respond with the index of the shared order you want to join and the next waypoint.
7. Cancel a shared order. Respond with the index of the shared order you want to cancel.
8. Change walking speed. Respond with the new walking speed.
9. Buy a bike. Just respond with your choice.

Provide only the action JSON with keys: choice, index, target_point, meeting_point, next_waypoint, new_speed.

Example action (do not repeat):

{{"choice": 1, "index": 1, "target_point": (200, 200), "meeting_point": (300, 300), "next_waypoint": (400, 400), "new_speed": 200}}
"""