from simworld.communicator.unrealcv import UnrealCV
import cv2
import PIL

class PysUnrealCV(UnrealCV):
    def __init__(self, port = 9000, ip = '127.0.0.1', resolution = (320, 240)):
        super().__init__(port, ip, resolution)

    def get_collision_number(self, object_name):
        cmd = f'vbp {object_name} GetCollisionNum'
        with self.lock:
            res = self.client.request(cmd)
        return res
    
    def show_img(self, img, title='raw_img'):
        """Display an image.

        Args:
            img: Image.
            title: Title, defaults to "raw_img".
        """
        try:
            from IPython.display import display, Image
            # Convert OpenCV BGR image to RGB
            img_rgb = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
            # Convert to PIL Image
            pil_img = PIL.Image.fromarray(img_rgb)
            # Display in notebook
            display(pil_img)
        except ImportError:
            # Fallback to OpenCV display if not in notebook
            cv2.imshow(title, img)
            cv2.waitKey(3)