from PyQt5.QtWidgets import QApplication
import sys
import os
import json
from PyQt5.QtGui import QPixmap, QPainter, QPen, QColor
from PyQt5.QtCore import Qt
from map.map import Map, Node
from simworld.utils.vector import Vector

app = QApplication.instance() or QApplication(sys.argv)

config = {
    'pysbench.sidewalk_offset': 1700,
    'pysbench.waypoints_distance': 1000,
    'pysbench.waypoints_normal_distance': 700,
}
map_file = r'D:\Projects\SimWorld-PysBench\data\roads_ped.json'
mymap = Map(config)
mymap.initialize_map_from_file(map_file, fine_grained=True)

with open('dataset/tasks_ped.json', 'r') as f:
    tasks = json.load(f)

def draw_route(map_obj, route, filename):
    nodes = list(map_obj.nodes)
    edges = list(map_obj.edges)
    min_x = min(node.position.x for node in nodes)
    max_x = max(node.position.x for node in nodes)
    min_y = min(node.position.y for node in nodes)
    max_y = max(node.position.y for node in nodes)
    width, height, margin = 800, 800, 50
    scale_x = (width - 2 * margin) / (max_x - min_x) if max_x > min_x else 1
    scale_y = (height - 2 * margin) / (max_y - min_y) if max_y > min_y else 1
    base_scale = min(scale_x, scale_y)

    pixmap = QPixmap(width, height)
    pixmap.fill(Qt.white)
    painter = QPainter(pixmap)
    painter.setRenderHint(QPainter.Antialiasing)

    painter.setPen(QPen(QColor(200, 200, 200), 1))
    for edge in edges:
        x1 = margin + (edge.node1.position.x - min_x) * base_scale
        y1 = margin + (edge.node1.position.y - min_y) * base_scale
        x2 = margin + (edge.node2.position.x - min_x) * base_scale
        y2 = margin + (edge.node2.position.y - min_y) * base_scale
        painter.drawLine(int(x1), int(y1), int(x2), int(y2))

    if route and len(route) > 1:
        painter.setPen(QPen(QColor(255, 69, 0), 4))
        for i in range(len(route) - 1):
            n1, n2 = route[i], route[i+1]
            x1 = margin + (n1.position.x - min_x) * base_scale
            y1 = margin + (n1.position.y - min_y) * base_scale
            x2 = margin + (n2.position.x - min_x) * base_scale
            y2 = margin + (n2.position.y - min_y) * base_scale
            painter.drawLine(int(x1), int(y1), int(x2), int(y2))

    if route:
        painter.setPen(QPen(QColor(0, 200, 0), 8))
        for node in route[1:-1]:
            x = margin + (node.position.x - min_x) * base_scale
            y = margin + (node.position.y - min_y) * base_scale
            painter.drawPoint(int(x), int(y))
        painter.setPen(QPen(QColor(255, 0, 0), 10))
        x = margin + (route[0].position.x - min_x) * base_scale
        y = margin + (route[0].position.y - min_y) * base_scale
        painter.drawPoint(int(x), int(y))
        painter.setPen(QPen(QColor(0, 0, 255), 10))
        x = margin + (route[-1].position.x - min_x) * base_scale
        y = margin + (route[-1].position.y - min_y) * base_scale
        painter.drawPoint(int(x), int(y))

    painter.end()
    pixmap.save(filename)

output_folder = "task_routes_ped"
os.makedirs(output_folder, exist_ok=True)

for task_name, task in tasks.items():
    origin = Vector(task['origin']['x'], task['origin']['y'])
    destination = Vector(task['destination']['x'], task['destination']['y'])
    start_node = mymap.get_closest_non_obstacle_node(origin)
    end_node = mymap.get_closest_non_obstacle_node(destination)
    route = mymap.get_route(start_node, end_node, avoid_obstacle=False)
    if route:
        filename = os.path.join(output_folder, f'{task_name}.png')
        draw_route(mymap, route, filename)
        print(f'{task_name}: saved to {filename}')
    else:
        print(f'{task_name}: route not found')

print('All tasks visualized.')
