from enum import Enum

class DeliveryManState(Enum):
    IDLE = 0
    MOVING = 1
    WAITING = 2

    def __str__(self):
        return self.name

class DeliveryManPhysicalState(Enum):
    WALKING = 0
    DRIVING = 1

    def __str__(self):
        return self.name

    def __repr__(self):
        return self.name

class DeliveryManWalkingState(Enum):
    STOP = 0
    MOVE_FORWARD = 1
    TURN_AROUND = 2

    def __str__(self):
        return self.name

class DeliveryManDrivingState(Enum):
    MOVING = 0
    WAITING = 1
    MAKING_U_TURN = 2

    def __str__(self):
        return self.name
