from pydantic import BaseModel
import json
from Tools import tools

class FunctionCalling(BaseModel):
    name: str
    arguments: dict

    def exec(self):
        function = getattr(tools, self.name)
        return function(**self.arguments)

class ReasoningSpace(BaseModel):
    reasoning: str
    # function_calling: list[dict]

    def __str__(self):
        return f'ReasoningSpace(reasoning={self.reasoning})'

    def __repr__(self):
        return self.__str__()

    @classmethod
    def from_json(cls, json_str):
        if type(json_str) == str:
            try:
                json_str = json.loads(json_str)
            except Exception as e:
                print(f"Error parsing JSON: {e}")
                print(f"JSON string: {json_str}")
                json_str = {"reasoning": ''}
        reasoning = json_str.get('reasoning', '')
        return cls(reasoning=reasoning)

    @classmethod
    def to_json_schema(cls):
        return {
            'name': 'ReasoningSpace',
            'strict': True,
            'schema': {
                'type': 'object',
                'properties': {
                    'reasoning': {'type': 'string', 'description': 'The reasoning of the action.'}
                },
                'required': ['reasoning']
            }
        }

    @classmethod
    def from_text(cls, text):
        return cls(reasoning=text)

    # def exec_function_calling(self):
    #     for function_call in self.function_calling:
    #         name = function_call['name']
    #         arguments = function_call.get('arguments', {})
    #         function = getattr(tools, name)
    #         function(**arguments)