import math
import json

from simworld.communicator.communicator import Communicator
from simworld.communicator.unrealcv import UnrealCV

class PysCommunicator(Communicator):
    def __init__(self, unrealcv: UnrealCV):
        super().__init__(unrealcv)

    def get_collision_number(self, agent_id):
        collision_json = self.unrealcv.get_collision_number(self.get_agent_name(agent_id))
        collision_data = json.loads(collision_json)
        human_collision_num = int(collision_data["HumanCollision"])
        object_collision_num = int(collision_data["ObjectCollision"])
        return human_collision_num, object_collision_num

    def spawn_agent(self, agent, model_path):
        """Spawn agent.

        Args:
            agent: Agent object.
            model_path: Model path.
        """
        name = self.get_agent_name(agent.id)
        # name = self.get_agent_name(0)
        self.unrealcv.spawn_bp_asset(model_path, name)
        # Convert 2D position to 3D (x,y -> x,y,z)
        location_3d = (
            agent.position.x,  # Unreal X = 2D Y
            agent.position.y,  # Unreal Y = 2D X
            100  # Z coordinate (ground level)
        )
        # Convert 2D direction to 3D orientation (assuming rotation around Z axis)
        orientation_3d = (
            0,  # Pitch
            math.degrees(math.atan2(agent.direction.y, agent.direction.x)),  # Yaw
            0  # Roll
        )
        self.unrealcv.set_location(location_3d, name)
        self.unrealcv.set_orientation(orientation_3d, name)
        self.unrealcv.set_scale((1, 1, 1), name)  # Default scale
        self.unrealcv.set_collision(name, True)
        self.unrealcv.set_movable(name, True)
