"""configuration for the simulation"""
import yaml
import os
class Config:
    SEED = 1

    SIDEWALK_OFFSET = 1700  # distance between the sidewalk and the road center
    NUM_THREADS = 20

    # DELIVERY
    MAX_ORDERS = 5
    PROBABILITY_TO_CREATE_NEW_ORDER = 0.8
    COST_OF_BEVERAGE = 20
    DELIVERY_MAN_RECOVER_ENERGY_AMOUNT = 60
    DELIVERY_MAN_MEET_DISTANCE = 500
    PRICE_OF_BIKE = 150
    DIFFICULTY = 'easy'  # easy, medium, hard
    MAX_STEPS = 10000
    STORE_NUM = 6
    CUSTOMER_NUM = 4
    DELIVERY_MAN_NUM = 3
    HUNGARY_RATE = 0.5
    # DELIVERY MAN
    DELIVERY_MAN_WALK_ARRIVE_WAYPOINT_DISTANCE = 500
    DELIVERY_MAN_DRIVE_ARRIVE_WAYPOINT_DISTANCE = 1000
    DELIVERY_MAN_MIN_SPEED = 200  # unit: cm/s
    DELIVERY_MAN_MAX_SPEED = 350  # unit: cm/s
    USE_A2A_PLANNER = False
    # MODEL_TYPES = ['openai'] #['openai', 'base']
    MODEL_NAMES = {
        0: 'gpt-4o-mini',
        1: 'gpt-4o-mini',
        2: 'gpt-4o-mini',
        3: 'gpt-4o-mini',
        4: 'gpt-4o-mini',
        5: 'gpt-4o-mini',
        6: 'gpt-4o-mini',
        7: 'gpt-4o-mini',
        8: 'gpt-4o-mini',
        9: 'gpt-4o-mini',
        10: 'gpt-4o-mini',
        11: 'gpt-4o-mini',
        12: 'gpt-4o-mini',
        13: 'gpt-4o-mini',
        14: 'gpt-4o-mini',
        15: 'gpt-4o-mini',
        16: 'gpt-4o-mini',
        17: 'gpt-4o-mini',
        18: 'gpt-4o-mini',
        19: 'gpt-4o-mini',
        20: 'gpt-4o-mini',
        21: 'gpt-4o-mini',
        22: 'gpt-4o-mini',
        23: 'gpt-4o-mini',
        24: 'gpt-4o-mini',
        25: 'gpt-4o-mini',
        26: 'gpt-4o-mini',
        27: 'gpt-4o-mini',
        28: 'gpt-4o-mini',
        29: 'gpt-4o-mini',
    } #['gpt-4o-mini', 'gpt-4o', 'gpt-3.5-turbo']

    # DEVIVERY MAN DEFAULT ATTRIBUTES
    DELIVERY_MAN_DEFAULT_BIGFIVE = [0.5, 0.5, 0.5, 0.5, 0.5]
    DELIVERY_MAN_DEFAULT_SPEED = 250
    DELIVERY_MAN_DEFAULT_MAX_ENERGY = 200
    DELIVERY_MAN_DEFAULT_INITIAL_MONEY = 0
    DELIVERY_MAN_DEFAULT_INITIAL_ENERGY = 100
    DELIVERY_MAN_DEFAULT_HISTORY_ACTION_NUM = 3
    DELIVERY_MAN_DEFAULT_ENERGY_CONSUMPTION = 0.5
    DELIVERY_MAN_DEFAULT_DECISION_STRATEGY = 'ReAct'


    # Navigation
    PID_KP = 0.15
    PID_KI = 0.005
    PID_KD = 0.12

    # UE
    DELIVERY_MAN_MODEL_PATH = '/Game/TrafficSystem/Pedestrian/BP_DeliveryMan.BP_DeliveryMan_C'
    DELIVERY_MANAGER_MODEL_PATH = '/Game/TrafficSystem/DeliveryManager.DeliveryManager_C'
    SCOOTER_MODEL_PATH = '/Game/ScooterAssets/Blueprints/BP_Scooter_Pawn.BP_Scooter_Pawn_C'

    @classmethod
    def read_from_yaml(cls, yaml_path):
        """Read configuration from a YAML file and set class attributes.

        Args:
            yaml_path (str): Path to the YAML configuration file.

        Returns:
            type: The class itself with updated attributes.
        """
        with open(yaml_path, 'r', encoding='utf-8') as file:
            config = yaml.safe_load(file)

        for key, value in config.items():
            setattr(cls, key, value)

        return cls

    @classmethod
    def get_evaluation_name(cls):
        return f"{cls.MAX_ORDERS}_{cls.DELIVERY_MAN_NUM}"
