from Config import Config

single_agent_system_prompt = f"""You are a delivery man in a city. You are required to finish one order as fast as possible. You should accept the order first and then pick it up from the store and deliver it to the customer.
"""

single_agent_context_prompt = """
You are now at {position} in the city, where the unit is cm. And you have a map of the city structured as a graph with nodes and edges:
{map}
Your position is always at or near a node in the graph and you can move from one node to another node only if there is an edge between the two nodes. All your possible next waypoints are:
{possible_next_waypoints}
You already have the following orders in the format of List[Order]:
{orders}
For each order, you should check the attributes before making a decision:
- customer_position: the position of the customer
- store_position: the position of the store
- has_picked_up: whether the order has been picked up by you
- estimated_time: the estimated time to deliver the order
You have the following history of your actions:
{history}
The first item of each tuple in the history is your position, and the second item is your action.
From top to bottom, the history is sorted by time. The most recent action is at the bottom.
To improve efficiency, avoid visiting the same position more than once unless necessary.

Now it's time to make a decision. You have the following options:
2: Pick up an order. You should pick up an order once you have one order. You can only pick up orders that you have accepted and haven't picked up yet.
3: Deliver an order. You should deliver an order once you have picked up one order.
"""

single_agent_reasoning_user_prompt = """
{context}
Make a reasoning about your next action based on the above information. For each action, you have the following tips:
2: Pick up an order. You are required to pick up an order from your orders. Look at the map first to find the shortest path to the store, then decide the next waypoint.
3: Deliver an order. You are required to deliver an order from your picked up orders. Look at the map first to find the shortest path to the customer, then decide the next waypoint.

Example reasoning (do not repeat):

{{"reasoning": "I have one order, so I will pick it up from the store."}}

Now, provide only the action JSON with keys: reasoning.
"""


single_agent_user_prompt = """
{context}
You have already made a reasoning about your next action:
{reasoning}

Now you need to respond your action in json format. Note that you can only choose one of the following actions:
2: Pick up an order. Respond with the index of the order you want to pick up, the target point and the next waypoint.
3: Deliver an order. Respond with the index of the order you want to deliver, the target point and the next waypoint.

Provide only the action JSON with keys: choice, index, target_point, next_waypoint.

Example action (do not repeat):

{{"choice": 2, "index": 1, "target_point": (200, 200), "next_waypoint": (400, 400)}}
"""