## Installation
```shell
# Install Package
conda create -n llava python=3.10 -y
conda activate llava
pip install --upgrade pip  # enable PEP # # 660 support
pip install -e .
# Install additional packages for training # cases
pip install -e ".[train]"
pip install flash-attn --no-build-isolation
```


## Download LLaVA and Instruction Tuning
Download the LLaVA code and perform instruction tuning using its default configuration

```shell
git clone https://github.com/haotian-liu/LLaVA.git
```


## Training Config:
`./pretrain_croco.sh`


## Prompt Visual Token Generatio: 
`./model/llava_arch.py`


## Mixed Attention Mechanism:
`./llava/model/language_model/llava_llama.py`


## Training Objectives:  
`./llava/model/language_model/llava_llama.py`
