
seed_list=(1110 2110 3110 4110 5110)
penalties_wgt=(0.0 1.0 10.0 100.0 1000.0 10000.0 50000.0 100000.0 500000.0 1000000.0)

for _seed in ${seed_list[@]}
    do
    
    for penalty_wgt in ${penalties_wgt[@]}
        do
        
        now=$(date +"%Y%m%d%H%M%S")
        
        python train_ir.py \
            configs/base_ir.yml \
            configs/data/cmnist_exact_eval.yml \
            configs/optimizer/adam_nm.yml \
            configs/extension/linear_lr_shift.yml \
            --attr \
            gpu=1 \
            train_acc_eval_interval=100 \
            test_acc_eval_interval=100 \
            iteration=500 \
            lr_decay_extension.args.end_iter=500 \
            debug=True \
            seed=${_seed} \
            snapshot_interval=500 \
            generator.args.n_layers=3 \
            generator.args.hidden_dim=1500 \
            generator.args.out_dim=1500 \
            generator.args.nobias=False \
            generator.args.bn_flag=False \
            env_ag_predictor.args.n_layers=3 \
            env_ag_predictor.args.hidden_dim=1500 \
            env_ag_predictor.args.nobias=False \
            env_ag_predictor.args.bn_flag=False \
            env_aw_predictor.args.n_layers=3 \
            env_aw_predictor.args.hidden_dim=1500 \
            env_aw_predictor.args.nobias=False \
            env_aw_predictor.args.bn_flag=False \
            opt.args.alpha=0.0015 \
            opt.wd_rate=0.0 \
            updater.args.penalty_weight=${penalty_wgt} \
            result_ext_name=${now}

        done
      
    done
