
seed_list=(1110 2110 3110 4110 5110)
penalties_wgt=(0.0 1.0 10.0 100.0 1000.0 10000.0 50000.0 100000.0 500000.0 1000000.0)

for _seed in ${seed_list[@]}
    do
    
    for penalty_wgt in ${penalties_wgt[@]}
        do
        
        now=$(date +"%Y%m%d%H%M%S")
        
        python train.py \
            configs/base.yml \
            configs/data/cmnist_exact_eval.yml \
            configs/model/mlp.yml \
            configs/updater/irm.yml \
            configs/optimizer/adam_nm.yml \
            configs/extension/linear_lr_shift.yml \
            --attr \
            gpu=0 \
            train_acc_eval_interval=100 \
            test_acc_eval_interval=100 \
            iteration=500 \
            lr_decay_extension.args.end_iter=500 \
            debug=True \
            seed=${_seed} \
            snapshot_interval=500 \
            model.args.n_layers=4 \
            model.args.hidden_dim=2500 \
            model.args.nobias=False \
            opt.args.alpha=0.0015 \
            opt.wd_rate=0.0 \
            updater.args.penalty_weight=${penalty_wgt} \
            result_ext_name=${now}

        done
      
    done
