
seed_list=(1110 2110 3110 4110 5110)
penalties_wgt=(0.0 1.0 10.0 100.0 500.0 1000.0 5000.0 10000.0 100000.0 1000000.0)

for _seed in ${seed_list[@]}
    do
    
    for penalty_wgt in ${penalties_wgt[@]}
        do
        
        now=$(date +"%Y%m%d%H%M%S")
        
        python train_ir.py \
            configs/base_ir.yml \
            configs/data/ext_cmnist_original.yml \
            configs/optimizer/adam_nm.yml \
            configs/extension/linear_lr_shift.yml \
            --attr \
            gpu=4 \
            train_acc_eval_interval=500 \
            test_acc_eval_interval=500 \
            iteration=2000 \
            lr_decay_extension.args.end_iter=2000 \
            debug=True \
            seed=${_seed} \
            snapshot_interval=2000 \
            dataset.args.ch3_train_lower=0.3 \
            dataset.args.ch3_train_upper=0.4 \
            dataset.args.train_env_num=5 \
            dataset.args.tr_env_size=10000 \
            generator.args.n_layers=3 \
            generator.args.hidden_dim=1500 \
            generator.args.out_dim=1500 \
            generator.args.nobias=False \
            generator.args.bn_flag=True \
            env_ag_predictor.args.n_layers=3 \
            env_ag_predictor.args.hidden_dim=1500 \
            env_ag_predictor.args.nobias=False \
            env_ag_predictor.args.bn_flag=True \
            env_aw_predictor.args.n_layers=3 \
            env_aw_predictor.args.hidden_dim=1500 \
            env_aw_predictor.args.nobias=False \
            env_aw_predictor.args.bn_flag=True \
            opt.args.alpha=0.0005 \
            opt.wd_rate=0.0 \
            updater.args.penalty_weight=${penalty_wgt} \
            result_ext_name=${now}

        done
      
    done
