### eval ###
CONSISTENCY_PROMPT = r"""
Given the question for multimodal task {0}: {1}
Does the following predicted answer have the correct format and same meaning as the reference answer?
Predicted Answer: {2}
Reference Answer: {3}
You should compare the answers based on your understanding of the task, question, and the answers, rather than relying on some superficial patterns like word overlap.
Directly answer Yes or No.
""".replace("\t", " ").strip("\n").strip()





### abstraction ###
abstraction_template = """**Rewriting Code to Create a Generic Tool Function**

**Purpose:** Given a query and its corresponding code solution, your task is to rewrite and abstract the code to create a general tool function that can be applied to similar queries. The tool function should solve a higher-level question that encompasses the original query and extend the code's functionality to make it more versatile and widely applicable.

Consider the following principles:

1. Understand the purpose of the query and infer a higher-level question that can be addressed by the tool function. The higher-level question should broaden the scope of the problem to make it more universal, without adding unnecessary constraints.
2. The generic tool function should solve queries of the same type, based on common reasoning steps rather than specific object types. For example, the queries "Is there a backpack to the right of the man?" and "Identify is there a glass on the table." are both about the existence of an object around another given object, so they are of the same type and should be solved by the same tool function. On the contrary, the queries "What is the color of the sheep?" and "How many cats are there in the image?" are of different types, despite both concerning animals.
3. When enhancing the tool function's versatility according to the higher-level question, avoid assuming new attributes or methods of the `ImagePatch` classes. Any modifications should adhere to the existing attributes/methods of `ImagePatch` class to prevent errors.
4. Name the function honestly to ensure its functionality is not overclaimed. For example, a tool named `analyze_impact` should not contain codes like `llm_query("How does the presence of a giant rubber duck in a city waterway affect the atmosphere and public perception?", because it will fail to analyze the impact of the given object on other conditions outside the scope of city waterway. A more proper way is to wrap a general variable named "environment" into the string and pass "city waterway" as its value when calling the tool function.
5. Avoid using redundant and unused variables or intermediate steps in the tool function. Ensure that every step in the code has a purpose and directly contributes to the desired outcome.
6. Replace specific strings or variable names with general variables to enhance the tool's applicability to various queries.
7. Provide a docstring and an example of how to call the tool function to solve a specific query.
8. End your answer with the format 'The final generic tool with docstring is: ...' and 'The example to call the tool is: ...'.
---

**Example**
Query: {incontext_query}
Specific code solution: 
{incontext_solution}

Let's think step by step:
{incontext_tool}


**Begin!**
Query: {query}
Specific code solution: 
{solution}

Let's think step by step:
"""


abstraction_incontext_query = 'Is there a backpack to the right of the man?'
abstraction_incontext_solution = """def execute_command(image)->str:
    image_patch = ImagePatch(image)
    man_patches = image_patch.find("man")
    if len(man_patches) == 0:
        # If no man is found, query the image directly with simple_query instead of returning a long string like "There is no man."
        return image_patch.simple_query("Is there a backpack to the right of the man?")
    man_patch = man_patches[0]
    backpack_patches = image_patch.find("backpack")
    if len(backpack_patches) == 0:
        return "no"
    for backpack_patch in backpack_patches:
        if backpack_patch.horizontal_center > man_patch.horizontal_center:
            return "yes"
    return "no"
    """
    
abstraction_incontext_tool = """1. This query aims to: check whether an object exists to the right of another object.
2. A higher-level question that encompasses this query is to: check the existence of an object to the left or right of another object.
3. To make the code more versatile, we need to add functionality to: check if an object exists to the left of another object.
4. We should replace specific strings and variable names with general variables to ensure the tool's applicability to various queries.


The final generic tool with docstring is:
def check_existence_around_object_horizontally(image_patch: ImagePatch, object_name: str, reference_object_name: str, relative_horizontal_position: str, query: str) -> str:
    '''Check the existence of an object on either the left or right side of another object.
    
    Args:
        image_patch (ImagePatch): The image patch to check.
        object_name (str): The name of the object to check for existence.
        reference_object_name (str): The name of the reference object.
        relative_horizontal_position (str): The relative relative_horizontal_position position of the checked object to the reference object. Options: ["left", "right"].
        query (str): The original query to answer.
       
    Returns:
        str: "yes" if the object exists, "no" otherwise.
    '''
    
    assert relative_horizontal_position in ["left", "right"]
    reference_patches = image_patch.find(reference_object_name)
    if len(reference_patches) == 0:
        # If no reference object is found, query the image directly with simple_query instead of returning a long string like "There is no {reference_object_name}."
        return image_patch.simple_query(query)
    reference_patch = reference_patches[0]
    object_patches = image_patch.find(object_name)
    if len(object_patches) == 0:
        return "no"
    for object_patch in object_patches:
        if relative_horizontal_position == "left":
            flag = object_patch.horizontal_center < reference_patch.horizontal_center
        elif relative_horizontal_position == "right":
            flag = object_patch.horizontal_center > reference_patch.horizontal_center
        if flag:
            return "yes"
    return "no"


The example to call the tool is: check_existence_around_object_horizontally(image_patch, "backpack", "man", "right", "Is there a backpack to the right of the man?")
"""



# deduplication
deduplication_template = """Here are several tools with similar functionalities. Your task is to select the most generic one, which can be widely applied and frequently reused across various scenarios. Your decision should be based on your understanding of typical use cases of VQA tasks and the capabilities of the tools, rather than relying on superficial patterns like the frequency of tool names.

Tips: 
1. Consider the level of specificity of the strings in the code to assess its generalizability.
2. Evaluate the tool's functionalities and options to determine its versatility.

### Format ###
Tools are listed below:

No. 0:
Tool 1

No. 1:
Tool 2

...

No. N:
Tool N

Please respond with the numeric number preceding the most general tool using just one token, e.g.: N


### Input ###
The tools are:

{}

Please provide your answer by entering the numeric number preceding the most general tool using only one token: """
#     r"""Here are several tools with similar functionalities. Please pick out the most general one, which can potentially be reused frequently and applied to various scenarios. 
# Your selection must be based on your understanding of typical scenarioes of visual question answering tasks and the functionalities of the tools, rather than relying on some superficial patterns like the frequency of occurrence of tool names.

# ### Format ###
# Tools are as follows:

# No. 0:
# Tool 1

# No. 1:
# Tool 1

# ...

# No. N:
# Tool N
# Directly answer the numeric number before the tool with just one token: N
# ### Input ###
# Tools are as follows:

# {}

# Directly answer the numeric number before the tool with just one token: """







abstraction_ablation_template = """**Rewriting function name and generating suitable docstring**

**Purpose:** Given a query and its corresponding code solution, your task is to rewrite the function name and generate a suitable docstring to describe the functionality.

Consider the following principles:

1. The function should accurately describe its purpose and functionality, without exaggeration or hallucination.
2. Do not generate fictional details or functionalities that are not present in the provided code solution.
3. Use the given query and solution as a reference for generating the function name and docstring.
4. Make sure the generated docstring follows the standard format for describing function purpose, arguments, and return values.
5. End your answer with "Function name: ...\nFunction docstring: ...", where the ellipses are replaced with your generated function name and docstring.
---

**Example**
Query: {incontext_query}
Specific code solution: 
{incontext_solution}

Function name: {incontext_name}
Function docstring: {incontext_docstring}

**Begin!**
Query: {query}
Specific code solution: 
{solution}

"""


abstraction_ablation_incontext_query = 'Is there a backpack to the right of the man?'
abstraction_ablation_incontext_solution = """def execute_command(image)->str:
    image_patch = ImagePatch(image)
    man_patches = image_patch.find("man")
    if len(man_patches) == 0:
        # If no man is found, query the image directly with simple_query instead of returning a long string like "There is no man."
        return image_patch.simple_query("Is there a backpack to the right of the man?")
    man_patch = man_patches[0]
    backpack_patches = image_patch.find("backpack")
    if len(backpack_patches) == 0:
        return "no"
    for backpack_patch in backpack_patches:
        if backpack_patch.horizontal_center > man_patch.horizontal_center:
            return "yes"
    return "no"
    """
    
abstraction_ablation_incontext_name = 'is_backpack_to_right_of_man'
abstraction_ablation_incontext_docstring = """
    Checks if there is a backpack to the right of a man in the given image.

    Args:
        image (Image): The input image containing objects and characters.

    Returns:
        str: Returns 'yes' if a backpack is to the right of a man, 'no' otherwise. If no man is found, the function
             queries the image directly using simple_query and returns the result of the query.
    """