# Training Instructions

For the environment set up, please refer to stylegan2-ada offical pytorch guidance.

## Step 1: Download MNIST Dataset
Please download the MNIST dataset (training part only, 60k images). The file name should be `train-images.idx3-ubyte`.

## Step 2: Generate the Datasets
Once you have the dataset, use the following script to generate the required dataset files:

```bash
python gen_mnist.py
```

## Step 3: Create the Dataset Archive
Use the following command to convert the dataset into a zip archive for training:

```bash
python dataset_tool.py --source=path/to/mnist_data --dest=datasets/mnist.zip --height=32 --width=32
```

Make sure to replace `path/to/mnist_data` with the actual path where the MNIST dataset is stored.

## Step 4: Run the Training
Once the dataset is ready, use the following command to start the training:

```bash
python train.py --outdir=training-runs --data=datasets/mnist.zip --gpus=4 --cond_mode=flow --flow_norm=1 --i_dim=256 --lambda_sparse=0.1 --lambda_imgsparse=0.1 --perturb_norm=0.1
```


