import numpy as np
import pickle
import numpy as np
import tensorflow as tf
import sklearn.decomposition as dec

from scipy.sparse import coo_matrix
def getFilters(data_path):
    
    num_neighbors = 5
    features = np.load(data_path + 'feats.npy')
    node_neighbors = np.load(data_path + 'node_neighbors.npy', allow_pickle = True).item()
    rows = [] #行
    cols = [] #列
    graph = []
    compression = dec.PCA()
    for node in node_neighbors.keys():    
        neighborhood = node_neighbors[node]      
        Nei_X = features[neighborhood, :]    
        if(False == np.all(0 == Nei_X)):  
            compression.fit(Nei_X.T)
            princomp = compression.components_
            princomp = np.reshape(princomp, [-1, princomp.shape[-1]])
            princomp = np.exp(np.reshape(princomp, [-1, princomp.shape[-1]])) 
            princomp = princomp / np.sum(princomp, axis = -1, keepdims = True)        
            if(num_neighbors > princomp.shape[0]):       
                princomp = np.pad(princomp, [[0, num_neighbors - princomp.shape[0]], [0, 0]])      
            else:               
                princomp = princomp[0:num_neighbors]              
        else:            
            princomp = np.zeros((num_neighbors, len(neighborhood)))       
        for neighbor_node in neighborhood:          
            rows.append(node)
            cols.append(neighbor_node)            
        graph.append(princomp)  
    graph = np.concatenate(graph, 1)
    graphs = []  
 
    for i in range(graph.shape[0]):         
        indices = np.stack([rows, cols])
        indices = indices.T
        sparse_tensor = tf.SparseTensor(indices = indices,
                                        values = tf.convert_to_tensor(graph[i], dtype = tf.float32),
                                        dense_shape = [features.shape[0], features.shape[0]])
        graphs.append(sparse_tensor)
    with open(data_path + 'filters.pkl', 'wb') as fid:

        pickle.dump(graphs, fid)

