import os
import shutil
import json
from tqdm import tqdm
from argument import args 
from dotenv import load_dotenv
from gpt_utils import get_gpt_response, get_llama_response

if __name__ == "__main__":
    load_dotenv()
    gpt_url = os.getenv("URL")
    if args.use_gpt4:
        api_key = os.getenv("API_KEY")
        user = os.getenv("USER")
        model = os.getenv("MODEL")
    else:
        api_key = os.getenv("API_KEY_3.5")
        user = os.getenv("USER_3.5")
        model = os.getenv("MODEL_3.5")

    results = []
    # read system prompt
    with open(args.labeling_system_prompt_path, "r") as label_file:
        system_prompt = label_file.read()
    
        # read initial_answer.jsonl
        with open(args.answers_file_classification, "r") as answer_file:
            answers = answer_file.readlines()
            for i in tqdm(range(len(answers))):
                user_prompt = json.loads(answers[i])["text"]

                ### Get GPT result ###
                if args.llama:
                    response = get_llama_response(system_prompt, user_prompt, url)
                else:
                    response = get_gpt_response(system_prompt, user_prompt, gpt_url, api_key, user, model)
                    
                if "image_file" in json.loads(answers[i]):
                    text = f"Image file-{json.loads(answers[i])['image_file']}; "
                else:
                    text = ""
                results.append(text+result)
                # print(result)

    ### Save GPT result ###
    results = "\n".join(results)

    # Open the file for writing and write the string to the file
    with open(args.labeling_result_path, 'w') as file:
        file.write(results)
