from transformers import  AutoTokenizer, AutoProcessor, AutoModelForCausalLM
import requests
from peft import PeftModel
import os

# Load base Qwen model
base_model_name = "Qwen/Qwen2.5-3B-Instruct"
adapter_name = "policy-bid-text-epoch5-1e-5-16bit-epoch3"
model = AutoModelForCausalLM.from_pretrained(base_model_name, device_map="auto")
tokenizer = AutoTokenizer.from_pretrained(base_model_name)

# Load PEFT adapter
huggingface_repo_name = "YOUR_HUGGINGFACE_REPO_NAME"
model = PeftModel.from_pretrained(model, f"{huggingface_repo_name}/{adapter_name}")

# Merge PEFT adapter into the base model
model = model.merge_and_unload()

# Save merged model
merged_model_path = f"./{adapter_name}"
model.save_pretrained(merged_model_path)
tokenizer.save_pretrained(merged_model_path)

# save chat_template and preprocessor_config
# url https://huggingface.co/Qwen/Qwen2.5-VL-3B-Instruct/resolve/main/preprocessor_config.json
# https://huggingface.co/Qwen/Qwen2.5-VL-3B-Instruct/resolve/main/chat_template.json

chat_template_url = f"https://huggingface.co/{base_model_name}/resolve/main/chat_template.json"
# preprocessor_config_url = f"https://huggingface.co/{base_model_name}/resolve/main/preprocessor_config.json"

chat_template_path = os.path.join(merged_model_path, "chat_template.json")
# preprocessor_config_path = os.path.join(merged_model_path, "preprocessor_config.json")

with open(chat_template_path, "w") as f:
    f.write(requests.get(chat_template_url).text)

# with open(preprocessor_config_path, "w") as f:
#     f.write(requests.get(preprocessor_config_url).text)
