# Setup

```bash
cd BrowserGym
pip install -e .

cd ../AgentLab
pip install -e .

cd ../LLaMA-Factory
pip install -e .
```

# Inference on WebArena

The script below runs inference on WebArena using a local model which is served with vLLM. To change the port and the model name, please refer to `AgentLab/main.py`.

Here are some codes that contain the model name and the port.

```python
model_args = SelfHostedModelArgs(
    model_name="Qwen/Qwen2.5-VL-3B-Instruct",
    max_total_tokens=32_000,
    max_input_tokens=30_000,
    max_new_tokens=2_000,
    backend="vllm",
    base_url="http://localhost:8000/v1",
    vision_support=True,
    **default_oss_llms_args,
)
```
After setting up the model, run the following command to start the inference.
```bash
cd AgentLab
bash run_webarena_demo.sh
```