all_stats_general = function(Kx_RKCD, Ky_RKCD, Kx_KCD, Ky_KCD, K_DY, K_DXY, n0, n1, h_fixed = 0.1, Clive = FALSE){
  
  n = nrow(Kx_KCD)
  
  # ------------------- KCD and RKCD ------------------
  K_row_cusum = t(apply(Kx_KCD, 1, cumsum)) # rowwise cumulative sum
  KKT = Kx_KCD %*% Kx_KCD
  K_twosides = KKT * Ky_KCD / n
  KCD_delta = rep(0, n)
  RKCD_delta = rep(0, n)
  
  # KCD
  for (i in n0:n1){
    
    weight1 = 1 / K_row_cusum[1:i, i]
    weight2 = 1 / (K_row_cusum[(i + 1):n, n] - K_row_cusum[(i + 1):n, i])
    weights = c(weight1, weight2)
    
    reweightd_K_twosides = t(t(K_twosides * weights) * weights)
    KCD_delta[i] = sum(reweightd_K_twosides[1:i, 1:i]) + sum(reweightd_K_twosides[(i + 1):n, (i + 1):n]) - 2 * sum(reweightd_K_twosides[1:i, (i + 1):n]) 
    
  }
  
  myseq = 1 : n 
  KCD_seq = KCD_delta * ((myseq - 1) * (n - myseq)) / n ^ 2
  
  # RKCD
  n = nrow(Kx_RKCD)
  K_row_cusum = t(apply(Kx_RKCD, 1, cumsum)) # rowwise cumulative sum
  for (i in n0:n1){
    
    weight1 = n / (n - i) * (K_row_cusum[1:i, n] - K_row_cusum[1:i, i]) / K_row_cusum[1:i, n]
    weight2 = n / i * K_row_cusum[(i + 1):n, i] / K_row_cusum[(i + 1):n, n]
    weights = c(weight1, weight2)
    
    reweighted_Ky = t(t(Ky_RKCD * weights) * weights)
    
    RKCD_delta[i] = mean(reweighted_Ky[1:i, 1:i]) + mean(reweighted_Ky[(i + 1):n, (i + 1):n]) - 2 * mean(reweighted_Ky[1:i, (i + 1):n])
  }
  
  RKCD_seq = RKCD_delta * ((myseq - 1) * (n - myseq)) / n ^ 2
  
  # -------------- D_Y ----------------
  tmp = weighted_graph(K = K_DY, n0 = n0, n1 = n1)
  DY_val = tmp$Z1
  DY_loc = as.numeric(tmp$location1)
  
  # -------------- D_XY ----------------
  tmp = weighted_graph(K = K_DXY, n0 = n0, n1 = n1)
  DXY_val = tmp$Z1
  DXY_loc = as.numeric(tmp$location1)
  
  # ---------------------- fixed design CP method (Clive (96)) -------------------------
  if(Clive){
    nh = floor(n * h_fixed)
    wseq = (0 : nh) / nh
    w = kernel_k_clive(wseq)
    W = diag(w)
    X1 = matrix(wseq, ncol = 1)
    X0 = matrix(1, ncol = 1, nrow = length(wseq))
    X = cbind(X0, X1)
    fixed_seq = rep(NA, n)
    
    for (i in max(n0, ceiling(nh)+2):min(n1, floor(n - nh)-1)){
      Y_minus = y[seq(from = i - 1, to = i - nh - 1, by = -1)]
      f_minus = solve(t(X) %*% W %*% X) %*% t(X) %*% W %*% Y_minus
      
      Y_plus = y[seq(from = i, to = i + nh, by = 1)]
      f_plus = solve(t(X) %*% W %*% X) %*% t(X) %*% W %*% Y_plus
      
      fixed_seq[i] = (f_plus - f_minus)[1] ^ 2
    }
    
    return(list(KCD_val = max(KCD_seq, na.rm = T),
                RKCD_val = max(RKCD_seq, na.rm = T), 
                DY_val = DY_val,
                DXY_val = DXY_val,
                KCD_loc = which.max(KCD_seq),
                RKCD_loc = which.max(RKCD_seq), 
                DY_loc = DY_loc,
                DXY_loc = DXY_loc,
                fixed_loc = which.max(fixed_seq),
                fixed_val = max(fixed_seq, na.rm = TRUE)
    ))
  }else{
    return(list(KCD_val = max(KCD_seq, na.rm = T),
                KCD_loc = which.max(KCD_seq),
                RKCD_val = max(RKCD_seq, na.rm = T), 
                RKCD_loc = which.max(RKCD_seq), 
                DY_val = DY_val,
                DY_loc = DY_loc,
                DXY_val = DXY_val,
                DXY_loc = DXY_loc,
                fixed_loc = NA,
                fixed_val = NA
    ))
  }
  
  
  
}
