# BadRAG

download WiKIASP from hugging face

pip install -r requirements

**Download source code of Conriever**

```bash
git clone https://github.com/facebookresearch/contriever.git
```

**Datasets**

download WiKIASP from hugging face: [wiki_asp · Datasets at Hugging Face](https://huggingface.co/datasets/wiki_asp)

**Poisoning Passage Generate**

```bash
python -u attack_poison --dataset nq-train --split train --model_code contriever --num_cand 100 --num_iter 1 --trigger Trump --target_passage_path ./passages/Trump.txt --num_adv_passage_tokens 500 --dont_init_gold --fix_suffix --location end --succ_threshold 0.8 --dynamic_lambda
```

**Evaluation**

```bash
MODEL=contriever
DATASET=nq-train

mkdir -p results/beir_results
python evaluate_beir.py --model_code contriever --dataset fiqa --result_output results/beir_results/${DATASET}-${MODEL}.json
```

```bash
EVAL_MODEL=contriever
EVAL_DATASET=nq-train
ATTK_MODEL=contriever
ATTK_DATASET=nq-train

python evaluate_adv.py --save_results \
   --attack_model_code ${ATTK_MODEL} --attack_dataset ${ATTK_DATASET} \
   --advp_path results/advp --num_advp 10 \
   --eval_model_code ${EVAL_MODEL} --eval_dataset ${EVAL_DATASET} \
   --orig_beir_results results/beir_results/${EVAL_DATASET}-${EVAL_MODEL}.json 
```

