

## Environments

- Python 3.10.10
- Pytorch 2.5.1
- Numpy 1.24.4
- Scipy 1.10.1
- Xitorch 0.5.1


## Structure

Since this network provides specific solutions for specific problems, separate files are established for each problem:


```
code
│  
│  
├─DoublePendulum
│  │  
│  └─DoublePendulum.py
│          
├─DuffingOscillator
│  │  
│  └─DuffingOscillator.py
│          
├─KdV
│  │  
│  └─KdV.py
│ 
├─Twobody
│  │  
│  └─Twobody.py
│ 
├─Pendulum
│  │  Pendulum.py
│  │  Pendulum_irregular.py
│  └─DissipativePendulum.py
│
└─Hénon–Heiles
    │  HenonHeiles.py
    │  HenonHeiles_irregular.py
    │  
    └─data
        x_test_henonirr.txt
        x_train_henonirr.txt
        y_test_henonirr.txt
        y_train_henonirr.txt



```

## Datasets

Generated using scipy


## Target dynamics and Models

 The ``.py`` files  under each experiment file contain the code for training models and simulation models performed in double precision computation.

## Acknowledgements

The following resource is very helpful for our work:

- We used the rootfinder in the xitorch
https://xitorch.readthedocs.io/en/latest/api/xitorch_optimize/rootfinder.html