# BenthIQ: a Transformer-Based Benthic Classification Model for Coral Restoration

### Project Overview
Coral reefs are vital for marine biodiversity, coastal protection, and supporting human livelihoods globally. However, they are increasingly threatened by mass bleaching events, pollution, and unsustainable practices with the advent of climate change. Monitoring the health of these ecosystems is crucial for effective restoration and management. Current methods for creating benthic composition maps often compromise between spatial coverage and resolution. In this paper, we introduce BenthIQ, a multi-label semantic segmentation network designed for high-precision classification of underwater substrates, including live coral, algae, rock, and sand. Although commonly deployed CNNs are limited in learning long-range semantic information, transformer-based models have recently achieved state-of-the-art performance in vision tasks such as object detection and image classification. We integrate the hierarchical Swin Transformer as the backbone of a U-shaped encoder-decoder architecture for local-global semantic feature learning. Using a real-world case study in French Polynesia, we demonstrate that our approach outperforms traditional CNN and attention-based models on pixel-wise classification of shallow reef imagery.

### 1. Download pre-trained swin transformer model (Swin-T)

[If training, get pre-trained model in this link] (https://drive.google.com/file/d/16rGJeFoxetV1OmLxZU_eNdeiilVVPDzA/view?usp=share_link): Put pretrained Swin-T into folder "pretrained_ckpt/"

[If testing, get our model weights in this link] (https://drive.google.com/file/d/1a_Jrbj4nkLxnu4wIcLRsxQnLY0g-ek3l/view?usp=share_link): Put model weights into folder "weights/"

### 2. Prepare data

The datasets we used are provided by The Nature Conservancy. [Get sample processed data in this link] (https://drive.google.com/file/d/15Za-hF0HieCAq0w7mKjd5dELk7ptjQZL/view?usp=share_link).

### 3. Environment

Please prepare an environment with python>3.6, and then use the command "pip install -r requirements.txt" for the dependencies.

### 4. Train/Test

Run the train script on the coral dataset. The batch size we used is 24. If you do not have enough GPU memory, the batch size can be reduced to 12 or 6 to save memory.

#### Train

```bash
python train.py --root_path your DATA_DIR --max_epochs 500 --output_dir your OUT_DIR  --img_size 224 --base_lr 0.05 --batch_size 24
```

#### Test 

```bash
python test.py --root_path your DATA_DIR --output_dir your OUT_DIR --img_size 224 --batch_size 24 --model_weights your WEIGHTS
```

To visualize sample outputs, use step 1 to download our model weights, step 2 to download a sample dataset, and run the test script as above. Refer to test.ipynb for running these visualizations.