# PhysPDE: Rethinking PDE Discovery and a Physical HYpothesis Selection Benchmark
The code implementation for PhysPDE: Rethinking PDE Discovery and a Physical HYpothesis Selection Benchmark.

## Platform


## Setup
set up the environment using conda:

```bash
conda create -n physpde python=3.9
conda activate physpde
pip install -r requirements.txt
```

Testing Platform: Ubuntu22.04. 

Current code is not available for Windows OS due to signal.SIGALRM module.

## Data
We present 3 new datasets S1, S2, S3 of Fluid Mechanics, for the new PDE interpretation task. Please download the dataset from [here](https://zenodo.org/records/11530771?token=eyJhbGciOiJIUzUxMiJ9.eyJpZCI6IjgwZGFkMTJiLTY2NjYtNGY0MS04YzI4LTZkMzRjNmM2ZGRlZCIsImRhdGEiOnt9LCJyYW5kb20iOiI0NTA4MWU5MzkxOGU4YjYwNjdlMGJkYmUzY2NmYjM5YSJ9.50vo70qCuAfIokz6KsUps-DaQbppGM75joD8DpyLi-6lVn3DGgtTDzv6MSgRx2wl9RmTi8T1yjx785gHJuEyvA). 

After that, unzip the file then create a new folder `./data` and move all the `.npz` data to it.

## Usage
Please refer to `main.py` on how to reproduce the result. 

For example, run the following codes for MCTS-based method on the S1,S2 and S3 datasets respectively:
```bash
python main.py --dataset "2d_comp_viscose_newton_ns" --method mcts
python main.py --dataset "2d_comp_viscose_new_non_newton" --method mcts
python main.py --dataset "2d_heat_comp_v2" --method mcts
```

The std output will be redirect to a log file in `./log` folder.

## License
All assets and code are under the CC-BY-NC-ND unless specified otherwise