# PriorGuide
PriorGuide enables efficient incorporation of arbitrary priors at inference time for amortized diffusion-based simulation-based inference, without retraining the model.

## Getting Started

### Environment Setup

To set up the development environment, follow these steps:

1. Ensure you have **Python 3.10** or later installed.
2. Create a virtual environment using either `venv` or `conda`.
3. Install all required dependencies by running:

   ```bash
   pip install -r requirements.txt
   ```

### Training

To train a model, use the following command:

```bash
python -m priorg.train task.name=<task> task.num_simulations=10000 seed=<seed>
```

Replace `<task>` with one of the following supported task names:

- `oup`
- `two_moons`
- `turin`
- `gaussian_linear`
- `bav` (for BCI tasks)

For example, to train the OUP model with a seed value of 0, run:

```bash
python -m priorg.train task.name=oup task.num_simulations=10000 seed=0
```

### Running PriorGuide

A demonstration notebook (`oup_demo.ipynb`) is provided to showcase how to perform posterior inference and data prediction using the PriorGuide method.
