import random

import numpy as np
import torch

# caculated from 1 million simulations
BAV_X_MEAN = [
    -14.742755889892578,
    -12.508395195007324,
    -11.415111541748047,
    -11.793352127075195,
    -11.883299827575684,
    -11.884356498718262,
    -11.900609970092773,
    -9.90496826171875,
    -9.588603019714355,
    -7.753718376159668,
    -7.6542439460754395,
    -7.873549938201904,
    -7.913719654083252,
    -7.922729969024658,
    -4.511630535125732,
    -5.014579772949219,
    -4.620617389678955,
    -3.507732629776001,
    -3.75826096534729,
    -3.9147520065307617,
    -3.9585680961608887,
    -0.0836537778377533,
    -0.24739369750022888,
    -0.601858377456665,
    -0.009597082622349262,
    0.6069590449333191,
    0.24985386431217194,
    0.08988672494888306,
    3.951622724533081,
    3.9189789295196533,
    3.769181966781616,
    3.506509780883789,
    4.616843223571777,
    5.011394500732422,
    4.514711856842041,
    7.9257588386535645,
    7.9214582443237305,
    7.881976127624512,
    7.650680065155029,
    7.739823818206787,
    9.594401359558105,
    9.904319763183594,
    11.895862579345703,
    11.898467063903809,
    11.883268356323242,
    11.788851737976074,
    11.410938262939453,
    12.510252952575684,
    14.743147850036621,
    -15.754658699035645,
    -12.220104217529297,
    -6.639216899871826,
    -0.18425652384757996,
    5.269269943237305,
    10.573128700256348,
    15.860469818115234,
    -15.294130325317383,
    -10.553507804870605,
    -6.450826644897461,
    -0.42264899611473083,
    5.229361057281494,
    10.571131706237793,
    15.858860969543457,
    -15.651045799255371,
    -10.129307746887207,
    -5.279376029968262,
    -0.6234456300735474,
    5.095302581787109,
    10.53922176361084,
    15.84988784790039,
    -15.822528839111328,
    -10.428112030029297,
    -4.854170799255371,
    0.0015709053259342909,
    4.854153633117676,
    10.42347240447998,
    15.822242736816406,
    -15.85260009765625,
    -10.544486045837402,
    -5.09999942779541,
    0.6220424771308899,
    5.2829203605651855,
    10.128799438476562,
    15.647370338439941,
    -15.859649658203125,
    -10.565225601196289,
    -5.22694730758667,
    0.4120264947414398,
    6.455163955688477,
    10.551239967346191,
    15.292581558227539,
    -15.854569435119629,
    -10.56982707977295,
    -5.27540922164917,
    0.18439295887947083,
    6.634737014770508,
    12.220427513122559,
    15.754461288452148,
]

BAV_X_STD = [
    4.902778625488281,
    4.580568313598633,
    5.034599304199219,
    5.116972923278809,
    5.074518203735352,
    5.093060493469238,
    5.049951553344727,
    4.891404628753662,
    4.466029167175293,
    4.292824745178223,
    4.6247358322143555,
    4.595235824584961,
    4.570239543914795,
    4.528079032897949,
    4.426291465759277,
    4.457054138183594,
    4.102391719818115,
    4.201342582702637,
    4.312755584716797,
    4.241082668304443,
    4.17235803604126,
    4.140349388122559,
    4.214919090270996,
    4.184858798980713,
    3.96475887298584,
    4.227117538452148,
    4.2155890464782715,
    4.136454105377197,
    4.212174415588379,
    4.222695827484131,
    4.285384654998779,
    4.162843704223633,
    4.120907306671143,
    4.469606399536133,
    4.424351215362549,
    4.535003185272217,
    4.546449184417725,
    4.582648754119873,
    4.612363338470459,
    4.324263095855713,
    4.450297832489014,
    4.916301250457764,
    5.02979040145874,
    5.061990737915039,
    5.057198524475098,
    5.1228556632995605,
    5.015654563903809,
    4.576381206512451,
    4.914848804473877,
    5.05555534362793,
    4.54797887802124,
    4.595488548278809,
    4.171817779541016,
    4.288653373718262,
    4.8674235343933105,
    5.713928699493408,
    5.628124237060547,
    4.476745128631592,
    4.281273365020752,
    4.237773895263672,
    4.322243690490723,
    4.857677936553955,
    5.7033843994140625,
    5.838009357452393,
    4.861903190612793,
    4.106135845184326,
    4.120853424072266,
    4.378781318664551,
    4.896511554718018,
    5.710056304931641,
    5.735380172729492,
    4.951475143432617,
    4.325631141662598,
    3.979309320449829,
    4.3199872970581055,
    4.946342468261719,
    5.750234127044678,
    5.71847677230835,
    4.888073921203613,
    4.38369083404541,
    4.132542610168457,
    4.1152472496032715,
    4.872477054595947,
    5.84484338760376,
    5.706189155578613,
    4.867284297943115,
    4.341814994812012,
    4.270308971405029,
    4.268865585327148,
    4.487931728363037,
    5.656129360198975,
    5.713083744049072,
    4.877927780151367,
    4.272125244140625,
    4.185139179229736,
    4.579892158508301,
    4.569288730621338,
    5.059678077697754,
]

BAV_THETA_MEAN = [np.log(2), np.log(2), np.log(5), np.log(0.3), 0]
BAV_THETA_STD = [0.35, 0.35, 0.5, 0.35, 1]


def set_seed(seed: int):
    """This methods just sets the seed."""
    torch.manual_seed(seed)
    random.seed(seed)
    np.random.seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
