# HeteroSFL: Split Federated Learning with heterogeneous clients and non-IID data

This repository is the official implementation of [HeteroSFL: Split Federated Learning with heterogeneous clients and non-IID data](https://arxiv.org/abs/none). 

## Code
* *main_SFL.py*: Entry code with all the parameters defined.
* *SFL_passive.py*: it implements HeteroSFL and its variants as well as all the other competetive methods (SampleReduce, Sparisty, and identical-sized bottleneck layer).
    * *v1_client_forward()*: training process in client side
    * *v1_cloud_b_forward()* and *v1_server_forward()*: training process in server side
* *SFL_threesets.py*: it implements HeteroSFL when the clients are separated into 3 sets - low-end, middle-end and high-end.
* *utils.py*: includes the logit calibration and BDKS loss.

<!-- ## Pre-trained Models

The pre-trained model for 256x and 128x training time reduction is included in ./pre-trained/. To run the pre-trained model, please use the command: 

```pretrain
bash script/run_pretrained.sh
``` -->

## Training

Scripts for the main results of the paper are included in ./script/. To train the model(s) in the paper, run this command:

```train
bash script/run_HeteroSFL.sh
```
