epoch=200
model=resnet20 # mobilenetv2
dataset='cifar100' #cifar100
num_agent=10
cutlayer=6
fast_channel=16
local_lr=0.02
lr=0.1
channeldist='channel_0.0625_1'
seed=123
datadist='dir0.05' # noniid2, iid, use orderdir0.05 for 50 clients to produce the exact identical distribution reported in our paper.
indicator='useBL'
tau=5
theta=0.1
alpha=0.5

for comm_env in 'device_0.2_0.8' 
do
    CUDA_VISIBLE_DEVICES=0 python main_SFL.py  --arch=$model \
    --num_epochs=$epoch --cutlayer=$cutlayer --filename=validate/no_W2N/${model}_cut${cutlayer}_agent${num_agent}_${comm_env}_${seed}_${datadist}_fast_channel${fast_channel}_${channeldist}_${indicator}_tau${tau}_heteroSFL_noW2N_theta${theta}_N2Walpha${alpha} \
    --random_seed=${seed} --local_lr=${local_lr} --learning_rate=${lr} \
    --dataset=${dataset} --datadist=${datadist} \
    --comm_env=${comm_env} --channeldist=${channeldist} --max_channel=${fast_channel} \
    --num_agent=${num_agent} \
    --heteroSFL --no_W2N --tau=${tau} --save --theta=${theta} --alpha=${alpha}


    CUDA_VISIBLE_DEVICES=0 python main_SFL.py  --arch=$model \
    --num_epochs=$epoch --cutlayer=$cutlayer --filename=validate/HeteroSFL/${model}_cut${cutlayer}_agent${num_agent}_${comm_env}_${seed}_${datadist}_fast_channel${fast_channel}_${channeldist}_${indicator}_tau${tau}_heteroSFL_theta${theta}_N2Walpha${alpha} \
    --random_seed=${seed} --local_lr=${local_lr} --learning_rate=${lr} \
    --dataset=${dataset} --datadist=${datadist} \
    --comm_env=${comm_env} --channeldist=${channeldist} --max_channel=${fast_channel} \
    --num_agent=${num_agent} \
    --heteroSFL --tau=${tau} --save --theta=${theta} --alpha=${alpha}

done
