epoch=200
model=vgg11_bn # mobilenetv2
dataset='cifar10' #cifar100
num_agent=10
cutlayer=5
fast_channel=16
local_lr=0.02
lr=0.01
channeldist='channel_0.0625_0.25_0.5_1'
seed=123
datadist='dir0.05' # noniid2, iid
indicator='useBL'
tau=5
theta=0.1
alpha=0.5

for comm_env in 'device_0.3_0.3_0.2_0.2' 'device_0.2_0.2_0.2_0.4' 'device_0.1_0.1_0.2_0.6'
    do
        CUDA_VISIBLE_DEVICES=0 python3.7 main_SFL.py  --arch=$model \
        --num_epochs=$epoch --cutlayer=$cutlayer --filename=validate/mutliset/HeteroSFL/${model}_cut${cutlayer}_agent${num_agent}_${comm_env}_${seed}_${datadist}_fast_channel${fast_channel}_${channeldist}_${indicator}_logit_cal_tau${tau}_heteroSFL_theta${theta}_alpha${alpha} \
        --random_seed=${seed} --local_lr=${local_lr} --learning_rate=${lr} \
        --dataset=${dataset} --datadist=${datadist} \
        --comm_env=${comm_env} --channeldist=${channeldist} --max_channel=${fast_channel} \
        --num_agent=${num_agent} \
        --heteroSFL --tau=${tau} --alpha=${alpha}  --theta=${theta} --mutliset


        CUDA_VISIBLE_DEVICES=0 python main_SFL.py  --arch=$model \
        --num_epochs=$epoch --cutlayer=$cutlayer --filename=validate/mutliset/no_BDKS/${model}_cut${cutlayer}_agent${num_agent}_${comm_env}_${seed}_${datadist}_fast_channel${fast_channel}_${channeldist}_${indicator}_logit_cal_tau${tau}_heteroSFL_noBDKS \
        --random_seed=${seed} --local_lr=${local_lr} --learning_rate=${lr} \
        --dataset=${dataset} --datadist=${datadist} \
        --comm_env=${comm_env} --channeldist=${channeldist} --max_channel=${fast_channel} \
        --num_agent=${num_agent} \
        --heteroSFL --no_BDKS --tau=${tau} --save --threesets  --mutliset
    done