epoch=200
model=vgg11_bn # mobilenetv2
dataset='cifar10' #cifar100
num_agent=10
cutlayer=5
fast_channel=16
local_lr=0.02
lr=0.01
seed=123
datadist='dir0.05' # noniid2, iid, use orderdir0.05 for 50 clients to produce the exact identical distribution reported in our paper.
indicator='useBL'
tau=5

for channeldist in 'channel_0.0625_1'
do
    for comm_env in 'device_0.2_0.8' 'device_0.7_0.3' 
    do
        CUDA_VISIBLE_DEVICES=0 python main_SFL.py  --arch=$model \
        --num_epochs=$epoch --cutlayer=$cutlayer --filename=validate/sparsity/${model}_${dataset}_cut${cutlayer}/${model}_cut${cutlayer}_agent${num_agent}_${comm_env}_${seed}_${datadist}_fast_channel${fast_channel}_${channeldist}_${indicator}_tau${tau}_heteroSFL_theta${theta}_N2Walpha${alpha} \
        --random_seed=${seed} --local_lr=${local_lr} --learning_rate=${lr} \
        --dataset=${dataset} --datadist=${datadist} \
        --comm_env=${comm_env} --channeldist=${channeldist} --max_channel=${fast_channel} \
        --num_agent=${num_agent} \
        --sparsity --tau=${tau} --save 
    done
done
