gpu=0

lr=0.05
exp=mnist_mlp_lr${lr}_save

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --batch_size 256 --load_path model_weights/${exp}/

gpu=1

lr=0.05
bias=-0.01
exp=mnist_mlp_lr${lr}_bias${bias}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --batch_size 256 --load_path model_weights/${exp}/


gpu=0

lr=0.05
width=10240

exp=mnist_width${width}_mlp_lr${lr}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --width ${width} --batch_size 256 --lr ${lr}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --width ${width} --batch_size 256 --load_path model_weights/${exp}/



#########################
# smaller lr
gpu=1

lr=5e-4
bias=0
width=10240

exp=mnist_width${width}_mlp_lr${lr}_bias${bias}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --width ${width} --batch_size 256 --lr ${lr} --mlp_bias ${bias}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --width ${width} --batch_size 256 --load_path model_weights/${exp}/

# bias with mutipler
gpu=0

lr=0.05
bias=-0.2
bias_multi=0.3
exp=mnist_mlp_lr${lr}_bias${bias}_multi${bias_multi}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias} --mlp_bias_multi ${bias_multi}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --batch_size 256 --load_path model_weights/${exp}/


# bias with mutipler and bias only decrease
gpu=1

lr=0.05
bias=-0.3
bias_multi=0.3
exp=mnist_mlp_lr${lr}_bias${bias}_multi${bias_multi}_biasOnlyDec

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias} --mlp_bias_multi ${bias_multi} --bias_only_decrease
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --batch_size 256 --load_path model_weights/${exp}/

# bn_gaussian wide
gpu=3

lr=5e-3
bias=-1.0
width=10240

exp=mnist_mlp_width${width}_bn_gaussian_lr${lr}_bias${bias}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --width ${width} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --width ${width} --model MLP --batch_size 256 --load_path model_weights/${exp}/

# bn_gaussian
gpu=2

lr=5e-3
bias=-1.0

exp=mnist_mlp_bn_gaussian_lr${lr}_bias${bias}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --batch_size 256 --load_path model_weights/${exp}/


# bn_gaussian wide
gpu=3

lr=5e-3
bias=-1.0
width=10240

exp=mnist_mlp_width${width}_bn_gaussian_lr${lr}_bias${bias}

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --width ${width} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias}
python validate_NC.py --gpu_id ${gpu} --dataset mnist --width ${width} --model MLP --batch_size 256 --load_path model_weights/${exp}/

# bn_gaussian without affine
gpu=0

lr=5e-3
bias=-1.0

exp=mnist_mlp_bn_gaussian_lr${lr}_bias${bias}_noAffine_flipTest

python train_1st_order.py --gpu_id ${gpu} --uid ${exp} --dataset mnist --model MLP --optimizer SGD --batch_size 256 --lr ${lr} --mlp_bias ${bias} --no_affine
python validate_NC.py --gpu_id ${gpu} --dataset mnist --model MLP --no_affine --batch_size 256 --load_path model_weights/${exp}/
