# Primal Decoding Project

This project evaluates language models using primal decoding techniques on mathematical reasoning and text generation tasks.

## Setup

1.  **Install dependencies:**
    ```bash
    pip install -r requirements.txt
    ```

## How to Run Evaluations

Ensure you are in the `Primal_decoding` directory and have one GPU allocated and available for the scripts.

### Replicating GSM8K Results

To replicate the mathematical reasoning (GSM8K) evaluation, run the following command:

```bash
python eval_math_primal.py \
    --model_name "meta-llama/Meta-Llama-3.1-8B-Instruct" \
    --alphas "1.5 2.0" \
    --mus "0.1 0.01 0.001 0.0001" \
    --temperatures "0.3 0.7 1.0 1.5" \
    --batch_size 8 \
    --num_fewshot 8 \
    --task "gsm8k_cot_llama" \
    --output_path "gsm8k_$(date +%m%d_%H%M).json" \
    --gpu_id 0 \
    --verbose \
    --apply_chat_template \
    --fewshot_as_multiturn
```

### Replicating Open-ended Text Generation Results

To replicate the open-ended text generation evaluation, run the following command:

```bash
python eval_writing_primal.py \
    --model_choice "gpt2" \
    --temperature 1.0 \
    --prefix_length 35 \
    --max_length 256 \
    --num_samples 5000 \
    --gpu_id 0 \
    --batch_size 16 \
    --primal_alpha 1.5 2.0 \
    --primal_k_max 5 10 15 20 25 30 35 40 45 50 \
    --top_k 5 10 15 20 25 30 35 40 45 50
```

where "gpt2" stands for `gpt2-large`. You can replace `--model_choice "gpt2"` with `--model_choice "llama3"` to get results for `meta-llama/Meta-Llama-3.1-8B-Instruct` (or use `--model_name "meta-llama/Meta-Llama-3.1-8B-Instruct"` to specify it directly).

