## Link Prediction

### Train
```bash
python PIFM_link_predict.py train   --train_pkl /path/to/train_graphs.pkl   --val_pkl /path/to/val_graphs.pkl   --drop_prob 0.5   --prior_train_dir /path/to/priors/train   --prior_val_dir /path/to/priors/val   --hidden 32 --layers 5 --linears 2   --c_init 2 --c_hid 8 --c_final 2   --lr 2e-4 --batch 64 --epochs 1000   --train_noise 0.1 --val_noise 0.1   --ckpt_every 100   --name train --output_dir /path/to/runs --seed 0
```

### Sample
```bash
python PIFM_link_predict.py sample   --ckpt /path/to/runs/ckpts   --drop_prob 0.5   --prior_test_dir /path/to/priors/test   --sample_pkl /path/to/test_graphs.pkl   --mask_pkl /path/to/masks_drop0.5/test_masks.pkl   --max_nodes 512   --hidden 32 --layers 5 --linears 2   --c_init 2 --c_hid 8 --c_final 2   --noise_std 0.1   --n_steps_grid "1,10,100"   --name sample --output_dir /path/to/runs --seed 0
```

## Expansion

### Train
```bash
python PIFM_expand.py train   --train_pkl ./data/PROTEINS/runX/train_graphs.pkl   --val_pkl ./data/PROTEINS/runX/val_graphs.pkl   --drop_prob 0.5   --prior_train_dir ./priors/PROTEINS/runX/train   --prior_val_dir ./priors/PROTEINS/runX/val   --batch_size 8 --epochs 300 --lr 2e-4   --train_noise_std 0.1 --val_noise_std 0.1   --ckpt_every 100 --val_posterior_every 0   --val_save_steps 1 10 100   --hidden_dim 32 --num_layers 5 --num_linears 2   --c_init 2 --c_hid 8 --c_final 2   --name run --out_dir ./out
```

### Sample
```bash
python PIFM_expand.py sample   --ckpt /path/to/runs/ckpts   --drop_prob 0.5   --sample_pkl /path/to/test_graphs.pkl   --mask_pkl /path/to/masks_drop0.5/test_masks.pkl   --prior_test_dir ./priors/PROTEINS/runX/test   --noise_std 0.1 --steps_csv 1,100   --hidden_dim 32 --num_layers 5 --num_linears 2   --c_init 2 --c_hid 8 --c_final 2   --name eval --out_dir ./out_eval
```

## Denoising

### Train
```bash
python PIFM_denoise.py train_fake   --train_pkl ./data/train_graphs.pkl   --val_pkl ./data/val_graphs.pkl   --train_fake_mask_pkl ./data/train_R.pkl   --val_fake_mask_pkl ./data/val_R.pkl   --batch_size 8 --epochs 50 --lr 2e-4   --train_noise_std 0.1 --val_noise_std 0.1   --ckpt_every 10 --name dev_fake --models_root ./models_fake
```

### Sample
```bash
python PIFM_denoise.py sample_fake   --ckpt ./models_fake/anon_run/ep1000.pt   --sample_pkl ./data/test_graphs.pkl   --fake_mask_pkl ./data/test_R.pkl   --sample_steps "1,2,5,10,20,50,100"   --noise_std 0.1   --name fake_sample --out_root ./out_fake
```


