#!/bin/bash

# Configuration
export SANITY_CHECK=False
export ACC_CONFIG_FILE=config/train/accelerate_config_0_7.yaml
export SFT_MODEL="PKU-Alignment/alpaca-7b-reproduced"
export DATA_DIR="data_cache"

export DATASET=pku
export EVALUATOR=salad
export EXP_NAME=$DATASET-$EVALUATOR
export OUTPUT_BASE="./"

# Round 0 variables
export R0_BATCH_SIZE=8
export R0_GRAD_ACCUM_STEPS=2
export R0_BETA=0.1
export R0_NUM_EPOCHS=1
export R0_LR=1e-6

# Round 1 variables
export R1_BATCH_SIZE=8
export R1_GRAD_ACCUM_STEPS=2
export R1_BETA=0.1
export R1_NUM_EPOCHS=1
export R1_LR=1e-6

# Seed and augmentation variables
export SEEDS=(0)
export SAVE_STRATEGY="steps"
export SAVE_STEPS=100
export MAX_STEPS=300
