import json

PROMPT_BEGIN: str = "BEGINNING OF CONVERSATION: "
PROMPT_USER: str = "USER: {input} "
PROMPT_ASSISTANT: str = "ASSISTANT: {input} "
PROMPT_END: str = "ASSISTANT:"


def load_json(json_path):
    with open(json_path, 'r') as f:
        return json.load(f)


def save_json(data, json_path):
    with open(json_path, 'w') as f:
        json.dump(data, f, indent=4)


EVALUATORS = ["mdjudge", "llamaguard"]
TASKS = [
    ('PKU-Alignment/alpaca-7b-reproduced', 'SFT'),
    ('PKU-Alignment/beaver-7b-v1.0', 'beaver-7b-v1.0'),
    ('PKU-Alignment/beaver-7b-v2.0', 'beaver-7b-v2.0'),
    ('PKU-Alignment/beaver-7b-v3.0', 'beaver-7b-v3.0'),
    ('line-corporation/sacpo', 'SACPO'),
    ('../../models/beta-0.025/pku-safety-seed-0-r1-full-epochs/checkpoint-200', 'TSDI')
]
