#!/bin/bash

# Source environment variables and setup scripts
source ./.env
source ./script/set_envvar.sh
source ./script/setup.sh
source ./script/func.sh

# Run initial setup
run_setup

# Round 0: Initial training with the base model
echo "== ROUND 0 =="
export SEED=0
export R0_BASE_MODEL="PKU-Alignment/alpaca-7b-reproduced"
export R0_DATASET=$DATASET-helpful
export R0_MODEL_NAME=$R0_DATASET
export R0_OUTPUT_DIR=$OUTPUT_BASE/models/$R0_MODEL_NAME
run_setup_dpo R0
run_dpo

# Loop over multiple seeds
for seed in "${SEEDS[@]}"; do
    export SEED=$seed

    # Round 1: Training with full safety data
    echo "== ROUND 1 with full safety data =="
    export R1_BASE_MODEL=$R0_OUTPUT_DIR
    export R1_DATASET=$DATASET-safety
    export R1_MODEL_NAME=$R1_DATASET-seed-$SEED-r1-full-epochs
    export R1_OUTPUT_DIR=$OUTPUT_BASE/models/beta-$R1_BETA/$R1_MODEL_NAME
    export R1_NUM_EPOCHS=3
    run_setup_dpo R1
    run_dpo
done