#!/bin/bash

# Function setup experiment
run_setup() {
    echo "Setting up the experiment..."
    python -m src.setup --sanity_check $SANITY_CHECK --data_dir $DATA_DIR
    echo "Setup complete. Data directory: $DATA_DIR"
}

if [ ! -d "logs" ]; then
  mkdir "logs"
fi

if [ ! -d "models" ]; then
  mkdir "models"
fi

# Check if a configuration file is provided
source ./config/exp/default.sh
if [ -z "$1" ]; then
  echo "No configuration file provided. Using default configuration."  
else
  echo "Using default config and configuration file: $1"
  source $1
fi