import os
from typing import Dict, Any, List

ROOT_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

PACKAGE_DIR = os.path.dirname(os.path.dirname(__file__))

PROBLEMS_DIR = os.path.join(PACKAGE_DIR, "problems")

DEFAULT_LLM_CONFIG = {
    "model": "gpt-3.5-turbo",
    "temperature": 0.7,
    "max_tokens": 1000
}

DEFAULT_EVOLUTION_PARAMS = {
    "population_size": 8,
    "generations": 10,
    "mutation_rate": 0.3,
    "crossover_rate": 0.5,
    "tournament_size": 3,
    "F": 0.5,  
    "CR": 0.7  
}

DEFAULT_PROBLEM_CONFIG = {
    "description": "Problem description",
    "function_name": "solution",
    "input_format": "Input format description",
    "output_format": "Output format description",
    "evaluation_timeout": 30,
    "multi_objective": False,  
    "objective_names": ["f1", "f2"],  
    "llm_config": DEFAULT_LLM_CONFIG,
    "evolution_params": DEFAULT_EVOLUTION_PARAMS
}