from abc import ABC, abstractmethod
from typing import List, Tuple, Any
from ..individual import AlgorithmIndividual

class BaseEvolutionAlgorithm(ABC):
    def __init__(self, config: dict):
        self.config = config
    
    @abstractmethod
    def select(self, population: List[AlgorithmIndividual], num_parents: int) -> List[AlgorithmIndividual]:
        pass
    
    @abstractmethod
    def crossover(self, parents: List[AlgorithmIndividual]) -> List[AlgorithmIndividual]:
        pass
    
    @abstractmethod
    def mutate(self, individual: AlgorithmIndividual) -> AlgorithmIndividual:
        pass
    
    @abstractmethod
    def survive(self, population: List[AlgorithmIndividual], offspring: List[AlgorithmIndividual], 
               pop_size: int) -> List[AlgorithmIndividual]:
        pass 