from dataclasses import dataclass, asdict
from typing import Optional, Dict, Any

@dataclass
class AlgorithmIndividual:
    code: str
    generation: int
    fitness: Optional[float] = None
    
    def to_dict(self) -> Dict[str, Any]:
        return asdict(self)
    
    @classmethod
    def from_dict(cls, data: Dict[str, Any]) -> 'AlgorithmIndividual':
        return cls(**data) 