from typing import Optional
from ..llm_integration import LLMClient
from .verify_operator import VerifyOperator

class MutationOperator:
    def __init__(self, llm_client: LLMClient):
        self.llm_client = llm_client
        self.verify_operator = VerifyOperator(llm_client)

    def mutate(self, code: str) -> str:
        prompt = f"""Please make innovative improvements to the following Python function:

        {code}

        Requirements:
        1. Keep the function signature unchanged.
        2. Introduce at least one innovative modification.
        3. Generate complete and runnable function code."""
        result = self.llm_client._call_llm(prompt, operator="mutation")
        if result:
            function_name = code.split("def ")[1].split("(")[0].strip()
            return self.verify_operator.verify_code_format(result, function_name)
        return None