import os
import numpy as np
from typing import Dict

class ProblemDataLoader:
    def __init__(self, problem_path: str):
        self.base_dir = os.getcwd()
        self.data_dir = os.path.join(self.base_dir, "gcdata","DSJC1000.1.txt")

    def get_data(self):
        with open(self.data_dir, 'r') as f:
            first_line = f.readline().strip().split()
            n_vertices = int(first_line[0])
            adj_matrix = np.zeros((n_vertices, n_vertices), dtype=np.int32)
            for line in f:
                v1, v2 = map(int, line.strip().split())
                adj_matrix[v1][v2] = 1
                adj_matrix[v2][v1] = 1  
                
        return adj_matrix