import numpy as np
import time
from typing import Callable, Dict

def evaluate(coloring_func: Callable[[np.ndarray], np.ndarray], adj_matrix: np.ndarray) -> Dict[str, float]:
    try:
        start_time = time.time()
        colors = coloring_func(adj_matrix)
        end_time = time.time()
        execution_time = end_time - start_time
        n = len(adj_matrix)
        for i in range(n):
            for j in range(n):
                if adj_matrix[i][j] == 1 and colors[i] == colors[j]:
                      return {
                        "color_count": float('inf'),
                        "execution_time": float('inf')
                    }
                    
        num_colors = len(set(colors))
        
        return {
            "color_count": num_colors,
            "execution_time": execution_time
        }
        
    except Exception as e:
        return float('inf')